<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'hello-elementor','hello-elementor-theme-style','hello-elementor-header-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION

add_action('after_setup_theme', function() {
    add_image_size('thumb-servicio', 300, 200, true); // true = crop exacto
});

/* --- PESTAÑAS DE CARGA: DIVIDIR TITULO EN mini / maxi --- */
add_action( 'wp_footer', function () { ?>
<script>
jQuery(function ($) {

  $('.servtabs .ue-tabs .ue-tab-btn > div').each(function () {
     const original = $(this).text().trim();
     const firstSpace = original.indexOf(' ');
     if (firstSpace === -1) return;          // títulos de una sola palabra

     const firstWord = original.slice(0, firstSpace);
     const rest      = original.slice(firstSpace + 1);

     $(this).html(
       '<span class="mini">' + firstWord + '</span>' +
       '<span class="maxi">' + rest      + '</span>'
     );
  });

});
</script>

<?php } );

// Registrar la cadena para Polylang (aparece en Idiomas > Traducciones de cadenas)
add_action('init', function () {
    if (function_exists('pll_register_string')) {
        pll_register_string('leer_mas_btn', 'Leer más', 'Elementor');
         pll_register_string('volver_noticias_btn', 'Volver a las noticias', 'Elementor'); // 👈 NUEVO
    }
});

// Shortcode [pll s="..."] -> devuelve la traducción de Polylang
add_shortcode('pll', function ($atts) {
    $s = isset($atts['s']) ? $atts['s'] : '';
    return function_exists('pll__') ? pll__($s) : $s;
});


function st_get_news_url() {
    $lang = function_exists('pll_current_language') ? pll_current_language('slug') : '';
    $base = get_page_by_path('noticias');
    if (!$base) $base = get_page_by_path('news');

    if ($base && function_exists('pll_get_post') && $lang) {
        $translated = pll_get_post($base->ID, $lang);
        if ($translated) return get_permalink($translated);
    }

    $slug = ($lang === 'en') ? 'news' : 'noticias';
    if ($p = get_page_by_path($slug)) return get_permalink($p);
    return home_url('/'.$slug.'/');
}
add_shortcode('news_url', function () {
    return esc_url( st_get_news_url() );
});
