<?php
/**
 * Plugin Name: Servicios con Tabs Interactivos
 * Description: Muestra un detalle del CPT 'servicio' con navegación tipo tabs mediante miniaturas, con diseño corporativo, dots y soporte Polylang.
 * Version: 1.8
 * Author: Steve Salas
 */

if (!defined('ABSPATH')) exit;

/**
 * Tamaño de imagen recortado para thumbs (300x200, crop).
 */
add_action('after_setup_theme', function(){
    add_image_size('thumb-servicio', 300, 200, true);
});

/**
 * Registrar cadenas para traducción en Polylang.
 */
add_action('init', function(){
    if (function_exists('pll_register_string')) {
        pll_register_string('leer_mas_text', 'Leer más', 'Servicios Tabs');
    }
});

/**
 * Obtener URL de la página de Servicios con soporte Polylang.
 */
function st_get_services_url(){
    $lang = function_exists('pll_current_language') ? pll_current_language('slug') : '';

    // Base: intenta con la página en español y obtener su traducción
    $base = get_page_by_path('servicios');
    if (!$base) $base = get_page_by_path('services');

    if ($base && function_exists('pll_get_post') && $lang) {
        $translated = pll_get_post($base->ID, $lang);
        if ($translated) return get_permalink($translated);
    }

    // Fallback por slug según idioma actual
    $slug = ($lang === 'en') ? 'services' : 'servicios';
    if ($p = get_page_by_path($slug)) return get_permalink($p);

    // Último recurso
    return home_url('/' . $slug . '/');
}

add_shortcode('servicios_tabs', 'servicios_tabs_shortcode');
function servicios_tabs_shortcode() {
    $leer_mas = function_exists('pll__') ? pll__('Leer más') : 'Leer más';
    $services_url = st_get_services_url();

    ob_start();
    ?>
    <style>
        @import url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css');

        .servicio-tabs-container { max-width: 1140px; margin: 0 auto; }
        .servicio-detalle { display: none; margin-bottom: 50px; }
        .servicio-detalle.active { display: flex; gap: 0; animation: fadeIn 0.3s ease-in-out; }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }

        .servicio-detalle img { width: 40%; height: 299px; object-fit: cover; }
        .servicio-contenido { width: 59%; padding: 40px 10px 0 0; background: #fff; border-top: 2px solid #cbcbcb; border-bottom: 2px solid #cbcbcb; display: flex; flex-direction: column; justify-content: flex-end; border-right: 2px solid #cbcbcb; margin-left: 30px; }

        .servicio-contenido h2 { font-family: "Montserrat", Sans-serif; font-size: 11px; font-weight: 400; text-transform: uppercase; color: #2FB4E9; }
        .servicio-contenido h2 strong { font-family: "Montserrat", Sans-serif; font-size: 19px; font-weight: 400; text-transform: uppercase; line-height: 22px; color: #1b1464; display:block; letter-spacing: -1px; }
        .servicio-contenido p.extracto { font-size: 14px; color: #4D4D4D; line-height: 1.4; margin-bottom: 20px; }

        .servicio-contenido .leer-mas-wrapper { text-align: right; }
        .servicio-contenido a.leer-mas { color: #2B2A7F; font-family: "Montserrat", Sans-serif; font-size: 12px; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; padding: 5px 20px; background: #fff; bottom: -10px; position: relative; }
        .servicio-contenido a.leer-mas::after { font-family: 'Font Awesome 6 Free'; font-weight: 900; content: "\f055"; color: #2fb4e9; font-size: 20px; line-height: 1; position: relative; top: 1px; }

        .servicio-thumbs { display: flex; flex-wrap: wrap; justify-content: center; border-top: 1px solid #ccc; gap: 10px; }
        .servicio-thumb { position: relative; flex: 1 1 calc((100% - 60px) / 7); max-width: calc((100% - 60px) / 7); aspect-ratio: 1 / 1; cursor: pointer; overflow: hidden; transition: 0.3s; }
        .servicio-thumb img { width: 100%; height: 100%; object-fit: cover; display: block; }
        .servicio-thumb .overlay { position: absolute; inset: 0; background: linear-gradient(to top, #009cde, transparent 100%); display: flex; justify-content: left; align-items: flex-end; padding: 8px; }
        .servicio-thumb .titulo-thumb { color: #fff; text-align: left; line-height: 1.2; }
        .servicio-thumb .titulo-thumb span.small { display: block; font-size: 10px; text-transform: uppercase; opacity: 0.8; }
        .servicio-thumb .titulo-thumb span.large { display: block; font-size: 14px; font-weight: bold; text-transform: uppercase; }
        .servicio-thumb.active .overlay { background: linear-gradient(to top, #004a7c, transparent 100%); }

        .servicio-dots { text-align: center; margin-top: 20px; }
        .servicio-dots .dot { display: inline-block; width: 15px; height: 15px; background-color: #ccc; border-radius: 50%; margin: 0 5px; cursor: pointer; }
        .servicio-dots .dot.active { background-color: #009cde; }
    </style>

    <div class="servicio-tabs-container">
        <div id="servicio-detalles">
            <?php
            $servicios = new WP_Query([
                'post_type' => 'servicio',
                'posts_per_page' => -1
            ]);
            $first = true; $index = 0;
            while ($servicios->have_posts()) : $servicios->the_post();
                $title_parts = explode(' ', get_the_title(), 2);
                ?>
                <div class="servicio-detalle<?php echo $first ? ' active' : ''; ?>" id="servicio-<?php the_ID(); ?>" data-index="<?php echo $index; ?>">
                    <img src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>" alt="<?php the_title_attribute(); ?>">
                    <div class="servicio-contenido">
                        <h2><span><?php echo esc_html($title_parts[0]); ?></span><strong><?php echo isset($title_parts[1]) ? esc_html($title_parts[1]) : ''; ?></strong></h2>
                        <p class="extracto"><?php echo esc_html(get_the_excerpt()); ?></p>
                        <div class="leer-mas-wrapper">
                            <a class="leer-mas" href="<?php echo esc_url($services_url); ?>"><?php echo esc_html($leer_mas); ?></a>
                        </div>
                    </div>
                </div>
                <?php $first = false; $index++; endwhile; wp_reset_postdata(); ?>
        </div>

        <div class="servicio-thumbs">
            <?php
            $servicios = new WP_Query([
                'post_type' => 'servicio',
                'posts_per_page' => -1
            ]);
            $first = true; $dot_index = 0;
            while ($servicios->have_posts()) : $servicios->the_post();
                $title_parts = explode(' ', get_the_title(), 2);
                ?>
                <div class="servicio-thumb<?php echo $first ? ' active' : ''; ?>" data-id="servicio-<?php the_ID(); ?>" data-index="<?php echo $dot_index; ?>">
                    <?php echo get_the_post_thumbnail(get_the_ID(), 'thumb-servicio'); ?>
                    <div class="overlay">
                        <div class="titulo-thumb">
                            <span class="small"><?php echo esc_html($title_parts[0]); ?></span>
                            <span class="large"><?php echo isset($title_parts[1]) ? esc_html($title_parts[1]) : ''; ?></span>
                        </div>
                    </div>
                </div>
            <?php $first = false; $dot_index++; endwhile; wp_reset_postdata(); ?>
        </div>

        <div class="servicio-dots">
            <?php for ($i = 0; $i < $dot_index; $i++) : ?>
                <span class="dot<?php echo $i === 0 ? ' active' : ''; ?>" data-index="<?php echo $i; ?>"></span>
            <?php endfor; ?>
        </div>
    </div>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const thumbs = document.querySelectorAll('.servicio-thumb');
        const detalles = document.querySelectorAll('.servicio-detalle');
        const dots = document.querySelectorAll('.servicio-dots .dot');

        function showByIndex(index) {
            detalles.forEach(el => el.classList.remove('active'));
            thumbs.forEach(el => el.classList.remove('active'));
            dots.forEach(el => el.classList.remove('active'));
            document.querySelector(`.servicio-detalle[data-index='${index}']`).classList.add('active');
            document.querySelector(`.servicio-thumb[data-index='${index}']`).classList.add('active');
            document.querySelector(`.servicio-dots .dot[data-index='${index}']`).classList.add('active');
        }
        thumbs.forEach(tab => tab.addEventListener('click', function(){ showByIndex(this.dataset.index); }));
        dots.forEach(dot => dot.addEventListener('click', function(){ showByIndex(this.dataset.index); }));
    });
    </script>
    <?php
    return ob_get_clean();
}
