<?php
/* WePay integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_wepay_class {
	var $default_parameters = array(
		"access-token" => "",
		"account-id" => "",
		"item-name" => "",
		"amount" => "",
		"currency" => "USD",
		"redirect-url" => ""
	);
	var $currency_list = array("USD", "CAD", "GBP");
	
	function __construct() {
		if (is_admin()) {
			add_filter('leform_payment_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-wepay-settings-html', array(&$this, "admin_settings_html"));
			add_filter('leform_payment_gateways_transaction_html_wepay', array(&$this, 'admin_details'), 10, 3);
		}
		add_filter('leform_payment_gateways_do_wepay', array(&$this, 'front_submit'), 10, 2);
		add_action("init", array(&$this, "front_init"));
	}
	
	function providers($_providers) {
		if (!array_key_exists("wepay", $_providers)) $_providers["wepay"] = esc_html__('WePay', 'leform');
		return $_providers;
	}

	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Access Token', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Please enter valid Access Token. You can find your Access Token on the "API Keys" tab of your app dashboard.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="access-token" value="'.esc_html($data['access-token']).'" />
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Account ID', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Please enter valid Account ID. You can find your Account ID on the "API Keys" tab of your app dashboard.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="account-id" value="'.esc_html($data['account-id']).'" />
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Item name', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Please enter the item name.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-input-shortcode-selector">
						<input type="text" name="item-name" value="'.(empty($data['item-name']) ? esc_html__('Membership Fee', 'leform') : esc_html($data['item-name'])).'" />
						<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Amount', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Set amount to pay and currency.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-group">
						<div class="leform-properties-content-9dimes leform-input-shortcode-selector">
							<input type="text" name="amount" value="'.esc_html($data['amount']).'" />
							<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
						</div>
						<div class="leform-properties-content-dime">
							<select name="currency" class="leform-100px">';
			foreach ($this->currency_list as $currency) {
				$html .= '<option value="'.esc_html($currency).'"'.($data['currency'] == $currency ? ' selected="selected"' : '').'>'.esc_html($currency).'</option>';
			}
			$html .= '
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Redirect URL', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('The URL your customer will be redirected to after the payment process.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-input-shortcode-selector">
						<input type="text" name="redirect-url" value="'.esc_html($data['redirect-url']).'" />
						<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
					</div>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['access-token']) || empty($data['access-token']) || empty($data['account-id']) || empty($data['account-id'])) return $_result;
		$data['amount'] = $leform->extract_number($data['amount']);
		if (empty($data['amount']) || !is_numeric($data['amount']) || $data['amount'] <= 0) return $_result;
		$post_data = array(
			'account_id' => $data['account-id'],
			'short_description' => (!empty($data['item-name']) ? $data['item-name'] : 'Fee'),
			'type' => 'personal',
			'amount' => number_format($data['amount'], 2, '.', ''),
			'currency' => $data['currency'],
			'reference_id' => $data["record-id"].'-'.time(),
			'callback_uri' => (defined('UAP_CORE') ? admin_url('do.php').'?leform-ipn=wepay' : get_bloginfo('url').'/?leform-ipn=wepay'),
			'hosted_checkout' => array(
				'redirect_uri' => empty($data['redirect-url']) ? $_SERVER["HTTP_REFERER"] : $data['redirect-url']
			)
		);
		$payment = $this->connect($data['access-token'], 'checkout/create', $post_data);
		if (is_array($payment) && array_key_exists('checkout_id', $payment) && array_key_exists('hosted_checkout', $payment)) {
			$html = '
	<form action="'.$payment['hosted_checkout']['checkout_uri'].'" method="get" target="_top" style="display: none !important;">
		<input type="submit" class="leform-pay" value="Submit">
	</form>';		
			$result = array('status' => 'OK', 'form' => $html, 'amount' => number_format($data['amount'], 2, '.', ''), 'currency' => $data["currency"], 'gateway-id' => $data['id']);
		} else {
			$result = array('status' => 'ERROR', 'message' => esc_html__('Can not connect to WePay server.', 'leform'));
		}
		return $result;
	}
	
	function front_init() {
		global $wpdb, $leform;
		$form_object = null;
		if (array_key_exists('leform-ipn', $_REQUEST) && $_REQUEST['leform-ipn'] == 'wepay') {
			if (!array_key_exists('checkout_id', $_REQUEST) || !array_key_exists('reference_id', $_REQUEST)) exit;

			$transaction_details = array();
			$item_id = intval($_REQUEST['reference_id']);
			if (($pos = strpos($item_id, "-")) !== false) $item_id = intval(substr($item_id, 0, $pos));
			$payer_id = 'Anonymous';
			$transaction_type = 'Unrecognized';
			$payer_name = $payer_id;
			$gross_total = 0;
			$txn_id = 'Unrecognized';
			$mc_currency = 'USD';
			$payment_status = 'Unrecognized';

			$record_details = $wpdb->get_row("SELECT t1.*, t2.name AS form_name, t2.options AS form_options, t2.elements AS form_elements FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' AND t1.id = '".esc_sql(intval($item_id))."'", ARRAY_A);
			if (!$record_details || !is_array($record_details) || !array_key_exists('gateway_id', $record_details)) $payment_status = "Error: no record";
			else {
				if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
				$form_object = new leform_form(intval($record_details['form_id']));
				if (empty($form_object->id)) $payment_status = "Error: no form";
				else {
					$payment_gateway = $form_object->get_payment_gateway($record_details['gateway_id']);
					if (empty($payment_gateway) || !is_array($payment_gateway)) $payment_status = "Error: no payment gateway";
					else {
						$payment = $this->connect($payment_gateway['data']['access-token'], 'checkout', array('checkout_id' => $_REQUEST['checkout_id']));
						if (array_key_exists('checkout_id', $payment) && $payment['checkout_id'] == $_REQUEST['checkout_id']) {
							$transaction_details = $payment;
							$transaction_type = $payment['type'];
							$gross_total = $payment['amount'];
							$txn_id = $payment['checkout_id'];
							$mc_currency = $payment['currency'];
							$payment_status = ucfirst($payment['state']);
							if (array_key_exists('payer', $payment) && array_key_exists('email', $payment['payer']) && !empty($payment['payer']['email'])) $payer_id = $payment['payer']['email'];
							if (array_key_exists('payer', $payment) && array_key_exists('name', $payment['payer']) && !empty($payment['payer']['name'])) $payer_name = $payment['payer']['name'];
							if ($payment['account_id'] != $payment_gateway['data']['account-id']) $payment_status = "Error: invalid recipient";
							else if (floatval($gross_total) < floatval($record_details["amount"]) || $mc_currency != $record_details["currency"]) $payment_status = "Error: invalid amount";
						}
					}
				}
			}
			$sql = "INSERT INTO ".$wpdb->prefix."leform_transactions (record_id, provider, payer_name, payer_email, gross, currency, payment_status, transaction_type, txn_id, details, created, deleted ) VALUES (
				'".$item_id."',
				'wepay',
				'".esc_sql($payer_name)."',
				'".esc_sql($payer_id)."',
				'".esc_sql(floatval($gross_total))."',
				'".esc_sql($mc_currency)."',
				'".esc_sql($payment_status)."',
				'".esc_sql($transaction_type)."',
				'".esc_sql($txn_id)."',
				'".esc_sql(json_encode($transaction_details))."',
				'".esc_sql(time())."',
				'0'
			)";
			$wpdb->query($sql);
			
			if ($payment_status == "Authorized") {
				$datestamp = date('Ymd');
				$timestamp = date('h');
				$stats_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_stats WHERE form_id = '".esc_sql($form_object->id)."' AND datestamp = '".esc_sql($datestamp)."' AND timestamp = '".esc_sql($timestamp)."'", ARRAY_A);
				if (!empty($stats_details)) {
					$wpdb->query("UPDATE ".$wpdb->prefix."leform_stats SET payments = payments + 1 WHERE id = '".esc_sql($stats_details['id'])."'");
				} else {
					$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_stats (form_id, impressions, submits, confirmed, payments, datestamp, timestamp, deleted) VALUES ('".esc_sql($form_object->id)."', '0', '0', '0', '1', '".esc_sql($datestamp)."', '".esc_sql($timestamp)."', '0')");
				}
				$wpdb->query("UPDATE ".$wpdb->prefix."leform_records SET status = '".esc_sql(LEFORM_RECORD_STATUS_PAID)."' WHERE id = '".esc_sql($item_id)."'");
				$form_object->form_data = json_decode($record_details['fields'], true);
				$form_object->form_info = json_decode($record_details['info'], true);
				$form_object->record_id = $record_details['id'];
				$form_object->do_notifications("payment-success", array('payment-amount' => $gross_total, 'payment-currency' => $mc_currency, 'payment-status' => $payment_status));
				$form_object->do_integrations("payment-success");
				do_action('leform_successfully_paid', $form_object);
			} else if ($payment_status == "Released") {
			} else {
				$wpdb->query("UPDATE ".$wpdb->prefix."leform_records SET status = '".esc_sql(LEFORM_RECORD_STATUS_UNPAID)."' WHERE id = '".esc_sql($item_id)."'");
				if (!empty($form_object) && !empty($form_object->id)) {
					$form_object->form_data = json_decode($record_details['fields'], true);
					$form_object->form_info = json_decode($record_details['info'], true);
					$form_object->record_id = $record_details['id'];
					$form_object->do_notifications("payment-fail", array('payment-amount' => $gross_total, 'payment-currency' => $mc_currency, 'payment-status' => $payment_status));
					$form_object->do_integrations("payment-fail");
					do_action('leform_unsuccessfully_paid', $form_object);
				}
			}
			exit;
		}
	}
	function admin_details($_html, $_transaction_details, $_pdf = false) {
		global $wpdb, $leform;
		$html = $_html;
		$details = json_decode($_transaction_details['details'], true);
		$html = '
		<table class="leform-record-details-table">';
		$html .= $this->_admin_details($details, 0, $_pdf);
		$html .= '
		</table>';
		
		return $html;
	}
	function _admin_details($_details, $_level = 0, $_pdf = false) {
		$html = '';
		foreach($_details as $key => $value) {
			if (is_array($value)) $html .= '<tr><td class="leform-record-details-table-name" style="'.($_pdf ? 'width:33%;' : '').'padding-left:'.number_format(0.4+$_level*1, 2, '.', '').'em;">'.esc_html($key).'</td><td class="leform-record-details-table-value"'.($_pdf ? ' style="width:67%;"' : '').'>...</td></tr>'.$this->_admin_details($value, $_level+1, $_pdf);
			else $html .= '
				<tr><td class="leform-record-details-table-name" style="'.($_pdf ? 'width:33%;' : '').'padding-left:'.number_format(0.4+$_level*1, 2, '.', '').'em;">'.esc_html($key).'</td><td class="leform-record-details-table-value"'.($_pdf ? ' style="width:67%;"' : '').'>'.esc_html(urldecode($value)).'</td></tr>';
		}
		return $html;
	}
	
	function connect($_access_token, $_path, $_data = array(), $_method = '') {
		$headers = array(
			'Content-Type: application/json;charset=UTF-8',
			'Accept: application/json',
			'User-Agent: Green Forms',
			'Authorization: Bearer '.$_access_token
		);
		try {
			if (strpos($_access_token, 'STAGE_') !== false) $url = 'https://stage.wepayapi.com/v2/'.ltrim($_path, '/');
			else $url = 'https://wepayapi.com/v2/'.ltrim($_path, '/');
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($_data));
			curl_setopt($curl, CURLOPT_TIMEOUT, 20);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			curl_close($curl);
			$result = json_decode($response, true);
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
	
}
$leform_wepay = new leform_wepay_class();
?>