<?php
/* Mad Mimi integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_madmimi_class {
	var $default_parameters = array(
		"username" => "",
		"api-key" => "",
		"list" => "",
		"list-id" => "",
		"fields" => array(
			"email" => "",
			"first_name" => "",
			"last_name" => "",
			"title" => "",
			"phone" => "",
			"country" => "",
			"state" => "",
			"city" => "",
			"address" => "",
			"zip" => "",
			"company" => ""
		),
		"custom-names" => array(),
		"custom-values" => array()
	);
	var $fields_meta;
	function __construct() {
		$this->fields_meta = array(
			'email' => esc_html__('Email address', 'leform'),
			'first_name' => esc_html__('First name', 'leform'),
			'last_name' => esc_html__('Last name', 'leform'),
			'title' => esc_html__('Title', 'leform'),
			'phone' => esc_html__('Phone #', 'leform'),
			'country' => esc_html__('Country', 'leform'),
			'state' => esc_html__('State', 'leform'),
			'city' => esc_html__('City', 'leform'),
			'address' => esc_html__('Address', 'leform'),
			'zip' => esc_html__('Postal Code', 'leform'),
			'company' => esc_html__('Company', 'leform'),
		);
		if (is_admin()) {
			add_filter('leform_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-madmimi-settings-html', array(&$this, "admin_settings_html"));
			add_action('wp_ajax_leform-madmimi-list', array(&$this, "admin_lists"));
		}
		add_filter('leform_integrations_do_madmimi', array(&$this, 'front_submit'), 10, 2);
	}
	
	function providers($_providers) {
		if (!array_key_exists("madmimi", $_providers)) $_providers["madmimi"] = esc_html__('Mad Mimi', 'leform');
		return $_providers;
	}
	
	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Username/email', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your Mad Mimi username or email.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="username" value="'.esc_html($data['username']).'" />
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('API Key', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your Mad Mimi API Key.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-key" value="'.esc_html($data['api-key']).'" />
					<label class="leform-integrations-description">'.sprintf(esc_html__('Find Mad Mimi API Key on %sAccount%s page (right side column).', 'leform'), '<a href="https://madmimi.com/user/edit?account_info_tabs=account_info_personal" target="_blank">', '</a>').'</label>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('List ID', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Select desired List ID.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-group leform-integrations-ajax-options">
						<input type="text" name="list" value="'.esc_html($data['list']).'" data-deps="username,api-key" readonly="readonly" />
						<input type="hidden" name="list-id" value="'.esc_html($data['list-id']).'" />
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Map form fields to Mad Mimi fields.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline">
						<table>';
		foreach ($this->default_parameters['fields'] as $key => $value) {
			$html .= '
							<tr>
								<th>'.esc_html($this->fields_meta[$key]).'</td>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" name="fields['.esc_html($key).']" value="'.esc_html(array_key_exists($key, $data['fields']) ? $data['fields'][$key] : $value).'" class="widefat" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
									<label class="leform-integrations-description">'.esc_html($this->fields_meta[$key].' ('.$key.')').'</label>
								</td>
							</tr>';
		}
		$html .= '				
						</table>
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Custom Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Configure Mad Mimi custom fields and map form fields to them.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline leform-integrations-custom" data-names="custom-names" data-values="custom-values">
						<table>
							<tr>
								<th>'.esc_html__('Name', 'leform').'</th>
								<td>'.esc_html__('Value', 'leform').'</td>
								<td style="width: 32px;"></td>
							</tr>';
		$i = 0;
		foreach ($data['custom-names'] as $key => $value) {
			if (empty($value)) continue;
			$html .= '
							<tr>
								<th>
									<input type="text" value="'.esc_html($value).'" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="'.esc_html(array_key_exists($key, $data['custom-values']) ? $data['custom-values'][$key] : '').'" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center">'.($i > 0 ? '<a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a>' : '').'</td>
							</tr>';
			$i++;
		}
		if ($i == 0) {
			$html .= '
							<tr>
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td></td>
							</tr>';
		}
		$html .= '				
							<tr style="display: none;" class="leform-integrations-custom-template">
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center"><a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a></td>
							</tr>
							<tr>
								<td colspan="3">
									<a class="leform-admin-button leform-admin-button-gray leform-admin-button-small" href="#" onclick="return leform_integrations_custom_add(this);"><i class="fas fa-plus"></i><label>'.esc_html__('Add Custom Field', 'leform').'</label></a>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function admin_lists() {
		global $wpdb, $leform;
		$lists = array();
		if (current_user_can('manage_options')) {
			if (array_key_exists('deps', $_REQUEST)) {
				$deps = json_decode(base64_decode(trim(stripslashes($_REQUEST['deps']))), true);
				if (!is_array($deps)) $deps = null;
			} else $deps = null;

			if (!is_array($deps) || !array_key_exists('username', $deps) || empty($deps['username']) || !array_key_exists('api-key', $deps) || empty($deps['api-key'])) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid Username or API Key.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			
			$result = $this->connect($deps['username'], $deps['api-key'], 'audience_lists/lists.json');
			if (is_array($result)) {
				if (sizeof($result) > 0) {
					foreach ($result as $list) {
						if (is_array($list)) {
							if (array_key_exists('id', $list) && array_key_exists('name', $list)) {
								$lists[$list['id']] = $list['name'];
							}
						}
					}
				} else {
					$return_object = array('status' => 'ERROR', 'message' => esc_html__('No lists found.', 'leform'));
					echo json_encode($return_object);
					exit;
				}
			} else {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid server response or API credentials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			if (empty($lists)) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('No lists found.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['items'] = $lists;
			echo json_encode($return_object);
		}
		exit;
	}

	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['username']) || empty($data['api-key']) || empty($data['list-id'])) return $_result;
		if (empty($data['fields']) || !is_array($data['fields'])) return $_result;
		if (empty($data['fields']['email']) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $data['fields']['email'])) return $_result;

		$post_data = $data['fields'];
		if (!empty($data['custom-names'])) {
			foreach($data['custom-names'] as $key => $name) {
				if (!empty($name) && !empty($data['custom-values'][$key])) $post_data[$name] = $data['custom-values'][$key];
			}
		}
		$result = $this->connect($data['username'], $data['api-key'], 'audience_lists/'.$data['list-id'].'/add', $post_data);
		return $_result;
	}
	
	function connect($_username, $_api_key, $_path, $_data = array(), $_method = '') {
		$headers = array(
			'Content-Type: application/json;charset=UTF-8',
			'Accept: application/json'
		);
		try {
			$url = 'http://api.madmimi.com/'.ltrim($_path, '/');
			if (empty($_data)) {
				if (strpos($url, '?') === false) $url .= '?';
				else $url .= '&';
				$url .= http_build_query(array('username' => $_username, 'api_key' => $_api_key));
			} else {
				$_data['username'] = $_username;
				$_data['api_key'] = $_api_key;
			}
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			if (!empty($_data)) {
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($_data));
			}
			if (!empty($_method)) {
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $_method);
			}
			curl_setopt($curl, CURLOPT_TIMEOUT, 120);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			curl_close($curl);
			$result = json_decode($response, true);
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
}
$leform_madmimi = new leform_madmimi_class();
?>