<?php
/* FreshMail integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_freshmail_class {
	var $default_parameters = array(
		"api-key" => "",
		"api-secret" => "",
		"list" => "",
		"list-id" => "",
		"fields" => array('email' => '')
	);
	
	function __construct() {
		if (is_admin()) {
			add_filter('leform_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-freshmail-settings-html', array(&$this, "admin_settings_html"));
			add_action('wp_ajax_leform-freshmail-list', array(&$this, "admin_lists"));
			add_action('wp_ajax_leform-freshmail-fields', array(&$this, "admin_fields_html"));
		}
		add_filter('leform_integrations_do_freshmail', array(&$this, 'front_submit'), 10, 2);
	}
	
	function providers($_providers) {
		if (!array_key_exists("freshmail", $_providers)) $_providers["freshmail"] = esc_html__('FreshMail', 'leform');
		return $_providers;
	}
	
	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('API Key', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your FreshMail API Key.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-key" value="'.esc_html($data['api-key']).'" />
					<label class="leform-integrations-description">'.sprintf(esc_html__('Find FreshMail API Key on %sIntegration%s page.', 'leform'), '<a href="https://app.freshmail.com/en/settings/integration/" target="_blank">', '/a').'</label>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('API Secret', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your FreshMail API Secret.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-secret" value="'.esc_html($data['api-secret']).'" />
					<label class="leform-integrations-description">'.sprintf(esc_html__('Find FreshMail API Secret on %sIntegration%s page.', 'leform'), '<a href="https://app.freshmail.com/en/settings/integration/" target="_blank">', '</a>').'</label>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('List ID', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Select desired List ID.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-group leform-integrations-ajax-options">
						<input type="text" name="list" value="'.esc_html($data['list']).'" data-deps="api-key,api-secret" readonly="readonly" />
						<input type="hidden" name="list-id" value="'.esc_html($data['list-id']).'" />
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Map form fields to FreshMail fields.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline">
						<table>
							<tr>
								<th>Email</td>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" name="fields[email]" value="'.esc_html(array_key_exists('email', $data['fields']) ? $data['fields']['email'] : '').'" class="widefat" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
									<label class="leform-integrations-description">'.esc_html__('Email Address', 'leform').'</label>
								</td>
							</tr>
						</table>
					</div>
					<div class="leform-properties-pure leform-integrations-ajax-inline">';
			if (!empty($data['api-key']) && !empty($data['api-secret']) && !empty($data['list-id'])) {
				$fields_data = $this->get_fields_html($data['api-key'], $data['api-secret'], $data['list-id'], $data['fields']);
				if ($fields_data['status'] == 'OK') $html .= $fields_data['html'];
			}
			$html .= '
					</div>
					<a class="leform-button leform-button-small" onclick="return leform_integrations_ajax_inline_html(this);" data-inline="fields" data-deps="api-key,api-secret,list-id"><i class="fas fa-download"></i><label>'.esc_html__('Load Fields', 'leform').'</label></a>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function admin_lists() {
		global $wpdb, $leform;
		$lists = array();
		if (current_user_can('manage_options')) {
			if (array_key_exists('deps', $_REQUEST)) {
				$deps = json_decode(base64_decode(trim(stripslashes($_REQUEST['deps']))), true);
				if (!is_array($deps)) $deps = null;
			} else $deps = null;

			if (!is_array($deps) || !array_key_exists('api-key', $deps) || empty($deps['api-key']) || !array_key_exists('api-secret', $deps) || empty($deps['api-secret'])) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API credetials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}

			$result = $this->connect($deps['api-key'], $deps['api-secret'], '/rest/subscribers_list/lists');
			if (is_array($result) && array_key_exists('status', $result) && $result['status'] == 'OK') {
				if (sizeof($result['lists']) > 0) {
					foreach ($result['lists'] as $list) {
						if (array_key_exists('subscriberListHash', $list) && array_key_exists('name', $list)) {
							$lists[$list['subscriberListHash']] = $list['name'];
						}
					}
				} else {
					$return_object = array('status' => 'ERROR', 'message' => esc_html__('No lists found.', 'leform'));
					echo json_encode($return_object);
					exit;
				}
			} else {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API credentials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['items'] = $lists;
			echo json_encode($return_object);
		}
		exit;
	}

	function admin_fields_html() {
		global $wpdb;
		if (current_user_can('manage_options')) {
			if (array_key_exists('deps', $_REQUEST)) {
				$deps = json_decode(base64_decode(trim(stripslashes($_REQUEST['deps']))), true);
				if (!is_array($deps)) $deps = null;
			} else $deps = null;
			if (!is_array($deps) || !array_key_exists('api-key', $deps) || empty($deps['api-key']) || !array_key_exists('api-secret', $deps) || empty($deps['api-secret']) || !array_key_exists('list-id', $deps) || empty($deps['list-id'])) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API credentials or List ID.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			$return_object = $this->get_fields_html($deps['api-key'], $deps['api-secret'], $deps['list-id'], $this->default_parameters['fields']);
			echo json_encode($return_object);
		}
		exit;
	}

	function get_fields_html($_api_key, $_api_secret, $_list, $_fields) {
		global $wpdb, $leform;
		$result = $this->connect($_api_key, $_api_secret, '/rest/subscribers_list/getFields', array('hash' => $_list));
		$fields_html = '';
		if (is_array($result) && array_key_exists('status', $result) && $result['status'] == 'OK') {
			if (sizeof($result['fields']) > 0) {
				$fields_html = '
			<table>';
				foreach ($result['fields'] as $field) {
					if (is_array($field)) {
						if (array_key_exists('tag', $field) && array_key_exists('name', $field)) {
							$fields_html .= '
				<tr>
					<th>'.esc_html($field['name']).'</td>
					<td>
						<div class="leform-input-shortcode-selector">
							<input type="text" name="fields['.esc_html($field['tag']).']" value="'.esc_html(array_key_exists($field['tag'], $_fields) ? $_fields[$field['tag']] : '').'" class="widefat" />
							<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
						</div>
						<label class="leform-integrations-description">'.esc_html($field['name'].' ('.$field['tag'].')').'</label>
					</td>
				</tr>';
						}
					}
				}
				$fields_html .= '
			</table>';
			} else {
				return array('status' => 'ERROR', 'message' => esc_html__('No fields found.', 'leform'));
			}
		} else {
			return array('status' => 'ERROR', 'message' => esc_html__('Inavlid API credentials.', 'leform'));
		}
		return array('status' => 'OK', 'html' => $fields_html);
	}

	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['api-key']) || empty($data['api-secret']) || empty($data['list-id'])) return $_result;
		if (empty($data['fields']) || !is_array($data['fields'])) return $_result;
		if (empty($data['fields']['email']) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $data['fields']['email'])) return $_result;

		$post_data = array(
			'email' => $data['fields']['email'],
			'list' => $data['list-id'],
			'state' => 1
		);
		foreach($data['fields'] as $key => $value) {
			if (!empty($value) && $key != 'email') {
				$post_data['custom_fields'][$key] = $value;
			}
		}
		$result = $this->connect($data['api-key'], $data['api-secret'], '/rest/subscriber/edit', $post_data);
		if (!is_array($result) || !array_key_exists('status', $result) || $result['status'] != 'OK') {
			$result = $this->connect($data['api-key'], $data['api-secret'], '/rest/subscriber/add', $post_data);
		}
		return $_result;
	}
	
	function connect($_api_key, $_api_secret, $_path, $_data = array(), $_method = '') {
		$_path = '/'.ltrim($_path, '/');
		$signature = sha1($_api_key.$_path.(!empty($_data) ? json_encode($_data) : '').$_api_secret);
		$headers = array(
			'X-Rest-ApiKey: '.$_api_key,
			'X-Rest-ApiSign: '.$signature,
			'Content-Type: application/json',
			'Accept: application/json'
		);
		try {
			$url = 'https://api.freshmail.com'.$_path;
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			if (!empty($_data)) {
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($_data));
			}
			if (!empty($_method)) {
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $_method);
			}
			curl_setopt($curl, CURLOPT_TIMEOUT, 120);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			curl_close($curl);
			$result = json_decode($response, true);
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
}
$leform_freshmail = new leform_freshmail_class();
?>