<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Anion_Elementor_Tabs_Widget extends \Elementor\Widget_Base {

	public function get_name() { return 'anion_tabs_widget'; }
	public function get_title() { return 'Anion Tabs (Imagen + Contenido)'; }
	public function get_icon() { return 'eicon-tabs'; }
	public function get_categories() { return array( 'general' ); }
	public function get_keywords() { return array( 'tabs', 'anion', 'producto', 'toallas' ); }

	protected function register_controls() {

		$this->start_controls_section(
			'section_tabs',
			array(
				'label' => 'Tabs',
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control('nav_title', array(
			'label' => 'Título del Tab',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Toalla Sanitaria de Día',
			'label_block' => true,
		));

		$repeater->add_control('use_same_image', array(
			'label' => 'Usar la misma imagen (Tab + Contenido)',
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => 'Sí',
			'label_off' => 'No',
			'return_value' => 'yes',
			'default' => 'yes',
		));

		$repeater->add_control('nav_img', array(
			'label' => 'Imagen miniatura (tab)',
			'type' => \Elementor\Controls_Manager::MEDIA,
			'condition' => array('use_same_image!' => 'yes'),
		));

		$repeater->add_control('content_img', array(
			'label' => 'Imagen del producto (se usa en contenido y/o tab)',
			'type' => \Elementor\Controls_Manager::MEDIA,
		));

		$repeater->add_control('title', array(
			'label' => 'Título del contenido',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Protector Diario Anion',
			'label_block' => true,
		));

		$repeater->add_control('desc', array(
			'label' => 'Descripción',
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => 'Escribe aquí la descripción del producto…',
		));

		$repeater->add_control('subtitle', array(
			'label' => 'Título secundario',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Detalles del producto:',
			'label_block' => true,
		));

		$list_rep = new \Elementor\Repeater();
		$list_rep->add_control('item', array(
			'label' => 'Detalle',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Sellada al vacío',
			'label_block' => true,
		));

		$repeater->add_control('details', array(
			'label' => 'Lista de detalles',
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $list_rep->get_controls(),
			'default' => array(
				array('item' => 'Sellada al vacío'),
				array('item' => 'Capa frontal tela tipo algodón'),
				array('item' => 'Medida de 15,5 cm'),
				array('item' => 'Biodegradable'),
				array('item' => 'Contenido: 30 unidades'),
			),
			'title_field' => '{{{ item }}}',
		));

		$this->add_control('tabs', array(
			'label' => 'Items',
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => array(
				array('nav_title' => 'Toalla Sanitaria de Día'),
				array('nav_title' => 'Toalla Sanitaria de Noche'),
				array('nav_title' => 'Protector Diario'),
			),
			'title_field' => '{{{ nav_title }}}',
		));

		$this->end_controls_section();

		// ESTILOS (colores + tipografías)
		$this->start_controls_section(
			'section_style',
			array(
				'label' => 'Estilos',
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control('tab_color', array(
			'label' => 'Color tab (texto)',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#e91e63',
		));

		$this->add_control('tab_color_active', array(
			'label' => 'Color tab activo / hover',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#c2185b',
		));

		$this->add_control('title_color', array(
			'label' => 'Color título',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#7cb342',
		));

		$this->add_control('subtitle_color', array(
			'label' => 'Color título secundario',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#e53935',
		));

		$this->add_control('arrow_color', array(
			'label' => 'Color flecha lista',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#7cb342',
		));

		$this->add_control('card_bg', array(
			'label' => 'Fondo “tarjeta” interna',
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => 'rgba(255,255,255,0.70)',
		));

		// Tipografías
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name' => 'typo_tab',
				'label' => 'Tipografía Tab',
				'selector' => '{{WRAPPER}} .anion-tabs__label',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name' => 'typo_title',
				'label' => 'Tipografía Título',
				'selector' => '{{WRAPPER}} .anion-tabs__title',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name' => 'typo_desc',
				'label' => 'Tipografía Descripción',
				'selector' => '{{WRAPPER}} .anion-tabs__desc',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name' => 'typo_subtitle',
				'label' => 'Tipografía Subtítulo',
				'selector' => '{{WRAPPER}} .anion-tabs__subtitle',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name' => 'typo_list',
				'label' => 'Tipografía Lista',
				'selector' => '{{WRAPPER}} .anion-tabs__list li',
			)
		);

		$this->end_controls_section();
	}

	private function anion_render_thumb($img): string {
		// Genera thumbnail real usando el ID (medium), para no cargar 2000px en tabs
		if ( empty($img) ) return '';
		$id = isset($img['id']) ? intval($img['id']) : 0;
		$url = isset($img['url']) ? $img['url'] : '';

		if ( $id ) {
			// medium por defecto, WordPress genera ~300-600px dependiendo de config
			$html = wp_get_attachment_image( $id, 'medium', false, array('class' => 'anion-tabs__thumb', 'alt' => '') );
			if ( $html ) return $html;
		}
		if ( $url ) {
			return '<img class="anion-tabs__thumb" src="'.esc_url($url).'" alt="">';
		}
		return '';
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$tabs = isset($settings['tabs']) ? $settings['tabs'] : array();
		if ( empty($tabs) ) return;

		if ( function_exists('anion_el_tabs_enqueue_assets_once') ) {
			anion_el_tabs_enqueue_assets_once();
		}

		$instance_id = 'anion-tabs-' . $this->get_id();

		$tab_color = !empty($settings['tab_color']) ? $settings['tab_color'] : '#e91e63';
		$tab_color_active = !empty($settings['tab_color_active']) ? $settings['tab_color_active'] : '#c2185b';
		$title_color = !empty($settings['title_color']) ? $settings['title_color'] : '#7cb342';
		$subtitle_color = !empty($settings['subtitle_color']) ? $settings['subtitle_color'] : '#e53935';
		$arrow_color = !empty($settings['arrow_color']) ? $settings['arrow_color'] : '#7cb342';
		$card_bg = !empty($settings['card_bg']) ? $settings['card_bg'] : 'rgba(255,255,255,0.70)';

		$style = sprintf(
			'--anion-tab-color:%s;--anion-tab-color-active:%s;--anion-title-color:%s;--anion-subtitle-color:%s;--anion-arrow-color:%s;--anion-card-bg:%s;',
			esc_attr($tab_color),
			esc_attr($tab_color_active),
			esc_attr($title_color),
			esc_attr($subtitle_color),
			esc_attr($arrow_color),
			esc_attr($card_bg)
		);

		echo '<div class="anion-tabs" id="'.esc_attr($instance_id).'" style="'.$style.'">';

		// NAV
		echo '<div class="anion-tabs__nav" role="tablist" aria-label="Productos">';
		foreach ( $tabs as $i => $t ) {
			$panel_id = $instance_id . '-panel-' . ($i+1);
			$btn_id   = $instance_id . '-tab-' . ($i+1);

			$nav_title = isset($t['nav_title']) ? $t['nav_title'] : 'Tab';

			$use_same = (isset($t['use_same_image']) && $t['use_same_image'] === 'yes');
			$nav_img = (!$use_same && !empty($t['nav_img'])) ? $t['nav_img'] : array();
			$content_img = !empty($t['content_img']) ? $t['content_img'] : array();
			if ( $use_same ) $nav_img = $content_img;

			echo '<button class="anion-tabs__btn" id="'.esc_attr($btn_id).'" type="button" role="tab" aria-selected="false" aria-controls="'.esc_attr($panel_id).'" tabindex="-1">';
			echo $this->anion_render_thumb($nav_img);
			echo '<span class="anion-tabs__label">'.esc_html($nav_title).'</span>';
			echo '</button>';
		}
		echo '</div>';

		// PANELS
		foreach ( $tabs as $i => $t ) {
			$panel_id = $instance_id . '-panel-' . ($i+1);

			$title = isset($t['title']) ? $t['title'] : '';
			$desc = isset($t['desc']) ? $t['desc'] : '';
			$subtitle = isset($t['subtitle']) ? $t['subtitle'] : '';
			$details = isset($t['details']) ? $t['details'] : array();

			$content_img_url = (!empty($t['content_img']) && !empty($t['content_img']['url'])) ? $t['content_img']['url'] : '';

			echo '<div class="anion-tabs__panel" id="'.esc_attr($panel_id).'" role="tabpanel">';
			echo '<div class="anion-tabs__card">';
			echo '<div class="anion-tabs__grid">';

			echo '<div class="anion-tabs__left">';
			if ( $title ) echo '<h3 class="anion-tabs__title">'.esc_html($title).'</h3>';
			if ( $desc )  echo '<div class="anion-tabs__desc">'.wp_kses_post($desc).'</div>';
			if ( $subtitle ) echo '<div class="anion-tabs__subtitle">'.esc_html($subtitle).'</div>';

			if ( ! empty($details) && is_array($details) ) {
				echo '<ul class="anion-tabs__list">';
				foreach ( $details as $d ) {
					$item = isset($d['item']) ? $d['item'] : '';
					if ( $item ) echo '<li>'.esc_html($item).'</li>';
				}
				echo '</ul>';
			}
			echo '</div>';

			echo '<div class="anion-tabs__right">';
			if ( $content_img_url ) {
				echo '<img src="'.esc_url($content_img_url).'" alt="">';
			}
			echo '</div>';

			echo '</div></div></div>'; // grid + card + panel
		}

		echo '</div>';
	}
}
