{{ ucfunc("put_docready_start") }}
		
  var jQuerytabs = jQuery('#{{uc_id}}');
    var htmlAccordion = jQuerytabs.find(".uc-accordion-contents-template").html();
    var g_scrollOffset = jQuerytabs.data("scroll-to-selected-tab-offset");
    
    //tabs options
    var tabsOptions = {
      
      startCollapsed: '{{start_hidden}}',
      setHash: {{set_url_hash}}, 
      {% if animation_tabs == "true" %}                       
      animation: 'fade', 
      {% endif %} 
      accordionAnchorHTML:htmlAccordion ,
      breakpoint: {{break_to_accordion}},
      
      {% if accordion_breakpoint == "true" %}
      collapsible: 'accordion',
      closeCurrent: true,
      {% else %}
      collapsible: 'tabs',
      closeCurrent: {{close_active_tab_on_click}},  
      {% endif %} 
      
    }
    
    //init tabs
    jQuerytabs.responsiveTabs('init', tabsOptions);    
    
    var isDesktopViewport = window.matchMedia("(min-width: 1024px)");
    var isMobileViewport = window.matchMedia("(max-width: 1024px)");
    var dataScrollToHead = jQuerytabs.data("scrolltohead"); 

    /**
    * animate the scroll
    */
    function scrollToTop(offsetTop, customOffset){
      
      jQuery('html, body').animate({
        scrollTop: offsetTop + customOffset
      }, 400);
    }
    
    /**
    * check if element in viewport 
    */
    function isElementInViewport(objElement) {
      
      var elementTop = objElement.offset().top;
      var elementBottom = elementTop + objElement.outerHeight();
      
      var viewportTop = jQuery(window).scrollTop();
      var viewportBottom = viewportTop + jQuery(window).height();
      
      var isInViwport = elementBottom > viewportTop && elementTop < viewportBottom;
      
      return(isInViwport);
      
    } 
        
    /**
    * scroll to head
    */
    function scrollToHead(activeTab){
      
      if(isElementInViewport(activeTab) == true)
      return(false);
      
      var jQuerytabsOffsetTop = jQuerytabs.offset().top;
      var tabsItemOffsetTop = activeTab.offset().top;
      
      if(isDesktopViewport.matches == true && dataScrollToHead == "desktop")
      scrollToTop(jQuerytabsOffsetTop, {{scroll_to_head_offset}});
      
      if(isMobileViewport.matches == true && dataScrollToHead == "mobile")
      scrollToTop(tabsItemOffsetTop, {{scroll_to_head_offset_mobile}});
      
      if(isDesktopViewport.matches == true && dataScrollToHead == "desktop+mobile")
      scrollToTop(jQuerytabsOffsetTop, {{scroll_to_head_offset}});
      
      if(isMobileViewport.matches == true && dataScrollToHead == "desktop+mobile")
      scrollToTop(tabsItemOffsetTop, {{scroll_to_head_offset_mobile}});
      
    } 

    /**
     * on hash change
     */
    function onHashChange(){

      if(!window.location.hash)
      return(false);

      var dataSetHash = jQuerytabs.data("hash");

      if(dataSetHash == false)
      return(false);

      //remove # sign from hash
      var hash = window.location.hash.replace("#", "");
      var objHashedTabs = jQuery("[data-hash-id="+hash+"]");

      //onetab for desktop mode and one for responsive
      objHashedTabs.each(function(){

        var objTab = jQuery(this);

        //inactive tab is invisible
        if(objTab.is(":visible") == false)
        return(true);

        //scroll to head if needed
        setTimeout(function(){
          scrollToHead(objTab);
        },600);

      });

    }
    
    /**
    * group funcitons and vars to reuse them after ajax refreshed
    */
    function initAdditionalTabsOptions(){
      
      jQuerytabs.data("tabs-loaded", true);	

      if(dataScrollToHead != "off"){
        {% if set_url_hash == "true" %}

          if(window.location.hash){

            var activeTabOnLoad = jQuery('[id=' + window.location.hash + ']');

            activeTabOnLoad.each(function(){

              var objTabOnLoad = jQuery(this);

              if(objTabOnLoad.is(":visible") == false)
              return(true);

              setTimeout(function(){
                scrollToHead(objTabOnLoad); 
              },200);            

            });

          }

        {% endif %}	
      }      
            
      var objTab = jQuerytabs.find('.r-tabs-anchor');
      
      //scroll to head after tab click event 
      objTab.on('click', function(){
        
        var activeTab = jQuery(this);
        
        if(dataScrollToHead != "off")
        scrollToHead(activeTab);
        
      });

      jQuery(window).on("hashchange", onHashChange);
            
    }
    
    
    initAdditionalTabsOptions();
    
    jQuerytabs.on("uc_ajax_refreshed", function(){
      
      jQuerytabs.responsiveTabs("init", "destroy");
      jQuerytabs.responsiveTabs("reinit", tabsOptions);
      initAdditionalTabsOptions();
      
    });
    
    
    var objRemoteOptions = {
      class_items:"r-tabs-tab",
      class_active:"r-tabs-state-active",
      selector_item_trigger:"a"
    };
    
    {{ucfunc("put_remote_parent_js","jQuerytabs","objRemoteOptions")}}  
    	
{{ ucfunc("put_docready_end") }}