#{{uc_id}} *{
	box-sizing: border-box;
}

#{{uc_id}}{
  display:flex;
  flex-direction:{{layout}};
  {% if layout == "row" %}
  	flex-direction:{{vertical_tab_position}};
  {% endif %}
  {% if layout == "column" %}
  	flex-direction:{{horizontal_tabs_position}};
  {% endif %}
  min-height:1px;
}

#{{uc_id}} .uc_tab_nav{
	list-style:none;
    display:flex;
    justify-content:{{justify}};
    {% if layout != "row" %}
        width:auto;  	 
    {% endif %}	
}


{% if layout == "row" %}
#{{uc_id}} > .uc_tab_nav{
	flex-direction:column;  	
}  
{% endif %}	

#{{uc_id}} .uc_tab_nav{

}


#{{uc_id}} .uc_tab_nav li{
	display:inline-flex;
	position:relative;
    z-index:1;
}

#{{uc_id}} .uc_tab_nav li a
{
  display:inline-flex;
  width:100%;
}
#{{uc_id}} .uc_tab_nav li .uc_circle{
    position: relative;
    border-radius: 50%;
    display: inline-block;
    line-height:1em;
}

#{{uc_id}} .ue_tab_icon
{
  line-height:1em;
}

#{{uc_id}} .ue_tab_icon svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .uc_circle_container
{
  display:flex;
  align-items:center;
  justify-content:center;
}
#{{uc_id}} .uc_tab_nav li .uc_circle span{
	display:block;
	position:relative;
	border-radius:50%;
	opacity:0;
    transition:0.3s;
}
#{{uc_id}} .uc_tab_nav li a{
	position:relative;
	text-decoration:none;
}

#{{uc_id}} .uc_tab_nav li a i{
	display:block;
}
#{{uc_id}} .uc_tab_nav li.r-tabs-state-active a{
}

#{{uc_id}} .uc_tab_nav li.r-tabs-state-active .uc_circle span{
	opacity:1;
}

#{{uc_id}} .panes{ 
  display:none;
}

#{{uc_id}} .r-tabs .r-tabs-tab {
    display: block;
    margin: 0;
    list-style: none;
}

#{{uc_id}} .r-tabs-panel {
    display: none;
}

#{{uc_id}} .r-tabs-accordion-title {
    display: none;
}
#{{uc_id}} .uc_tab_nav{
  padding-inline-start: 0;
}
{% if animation_tabs == "true" %}

  #{{uc_id}} > .uc_tab_content{
      position: relative;
  }

  #{{uc_id}} .uc_tab_content > .r-tabs-state-default{
      position: absolute;
      top: 0;
      left: 0;
  }

  #{{uc_id}} .uc_tab_content .r-tabs-state-active{
      position: static;
  }

{% endif %}


{% if accordion_breakpoint == "true" %}   
@media only screen and (max-width: {{break_to_accordion}}px){
   #{{uc_id}} ul.tabs {
     display:none;
   }
   #{{uc_id}} .r-tabs .r-tabs-nav { 
     display: none;
   }
  #{{uc_id}} .r-tabs-accordion-title {
      display:block;
  }
  #{{uc_id}} .r-tabs-accordion-title .r-tabs-anchor{ 
      display:flex;
      align-items:center;
      overflow:hidden; 
 }
 #{{uc_id}} .uc-tabs-accordion-title{
  /*  display:flex; */
    display: block;
    align-items:center;
    flex-grow:1;
 }
  #{{uc_id}} .r-tabs-panel {
    display: none;
  }
  #{{uc_id}} .uc_circle
  {
    display:none;
  }
  #{{uc_id}} .uc_tab_content
  {
    width:100%;
  }
  
  #{{uc_id}} .uc_tab_content > .r-tabs-state-default{
      position: static;
  }
  
  #{{uc_id}} .r-tabs-state-default{
	position: static;
  }
  #{{uc_id}} .r-tabs-accordion-title .uc-accordion-icon-collapse{
    display:none;    
  }
  
  #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-collapse{
    display:block;
  }
  
  #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-expand{
    display:none;
  }
  #{{uc_id}} .uc-accordion-icon svg{
    width:1em;
    height:1em;
  }
}
{% endif %}

{% if layout == "row" %}
	#{{uc_id}} .uc_tab_nav
    {
      flex-grow:0;
      flex-shrink:0;
    }
{% endif %}

ul.uc_tab_nav{
  margin:0;
}