function ucObserveMap() {
	const observer = new IntersectionObserver( entries => {
      for( const entry of entries ) {
          if(entry.isIntersecting) { 
              ucRunGoogleMap{{uc_serial}}()
              observer.disconnect()
          }
      }
    })
    
  	observer.observe( document.querySelector('#{{uc_id}}') )
}

function ucInitGoogleMap{{uc_serial}}() {
  {% if load_on_screen_entry == 'true' %}
    ucObserveMap()
  {% else %}
	if (jQuery('#{{uc_id}}').is(':hidden') ) {
      ucObserveMap()
    } else {	
 		ucRunGoogleMap{{uc_serial}}()
    }
  {% endif %}
}
   
/*
* get items data using html (js is not updating after filters)   
*/
function getItemsData(){
  var itemsData = [];
  var objSettingItems = jQuery("#{{uc_id}} .ue-google-map-setting-item");
  
  if(!objSettingItems || objSettingItems.length == 0)
    return(null);
  
  objSettingItems.each(function(){
  	var objSettingItem = jQuery(this);
    var dataSettings = objSettingItem.attr("data-settings");
    var settings = JSON.parse(dataSettings);
    
    itemsData.push(settings);
  });  
  
  return(itemsData);
}
   
/**
* set category index to items data
*/
function setCategoryIndex(markersItems){
  if(!markersItems)
    return(false);
  
  let currentCategory = 0;
  
  markersItems.forEach( (item, index) => {     
      
      if( item.item_type == 'category' ) {          
        currentCategory++
        item.category_index = currentCategory            
      } else if ( item.item_type == 'place' ) {        
        if ( currentCategory == 0 ) {
          item.category_index = null
        }
          
        item.category_index = currentCategory        
      }
  })
}   
   
function ucRunGoogleMap{{uc_serial}}(isRefreshed = false) {
    
  const categories = document.querySelectorAll('#{{uc_id}} .ue-google-map_category').forEach( category => {
  	const itemsTotal = category.querySelectorAll('.ue-google-map_places-item').length
    category.querySelector('.ue-google-map_category-items-count').textContent = `(${itemsTotal})`
  })

  const infoWindowItems = document.querySelectorAll('#{{uc_id}} .ue-google-map__info-window');	
  const markersItems = getItemsData();   
 
  //set category item index
  setCategoryIndex(markersItems);
	
  let mapStyle;

  {% if (style_category == "google") %} 
    {% if (google_styles != "standard") %} 
        mapStyle = '{{uc_assets_url}}' + '{{google_styles}}'
      {% else %}
        mapStyle = null
      {% endif %}
  {% elseif  (style_category == "custom") %}
    mapStyle = {{custom_map_style|raw}}
  {% endif %}

  options = {
    dom: document.querySelector('#{{uc_id}} .ue-google-map__wrapper'),
    assetsURL: '{{uc_assets_url}}',
    mapType: '{{map_type}}',    
    mapOptions: {
        zoom: {{zoom_level_nounit}},
        center: {
            lat: {% if (latitude != "") %} parseFloat('{{latitude|raw}}'.replace(',','.')) {% else %}null{% endif %},
            lng: {% if (longitude != "") %} parseFloat('{{longitude|raw}}'.replace(',','.')) {% else %}null{% endif %},
        },
        address: {% if (address != "") %} '{{address|raw}}' {% else %} 'New York' {% endif %} ,
        
    },
    mapControls: {
        mapTypeControl: {{show_map_type}},
        mapTypeControlOptions: {
            style: '{{map_type_control_style}}',
            mapTypeIds: [ {% for value in map_types %} 
                          '{{value}}',
                        {% endfor %}
                        ],        
  	},
    zoomControl: {{show_zoom}},
    streetViewControl: {{show_streetview}},
    rotateControl: {{show_rotate}},
    scaleControl: {{show_scale}},
    fullscreenControl: {{show_fullscreen}},
    scrollwheel: {{zoom_on_scrollwheel}},
    },
    mapStyleCategory: '{{style_category}}',
    mapStyle: mapStyle,
    markers: markersItems,
    infoWindowOptions: {
      showInfoWindow: {{show_info_window}},
      openByDefault: {{open_by_default}},
      centerInfoWindow: {{center_info_window}},
    },
    infoWindowContent: infoWindowItems,
    finderTool: {
      show: {{show_the_locator_tool}},
      wrapper: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool'),
      latitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-latitude input'),
      longitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-longitude input'),
      addressEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-address input'),
      addressBtnEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-address .ue-google-map__locator-tool-address__search'),
      copyIcons: document.querySelectorAll('#{{uc_id}} .ue-google-map__locator-tool .ue-google-map__locator-tool__button-copy'),
      geocodeCoordinatesIcon: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-longitude .ue-google-map__locator-tool-longitude__search'),
      zoomEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-zoom input'),
      notesEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-notes input'),
      currentWrapper: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-location-wrapper'),
      currentWrapperToggle: document.querySelector('#{{uc_id}} .ue-google-map__locator-hide-show-map-current'),
      currentLatitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-latitude input'),
      currentLongitudeEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-longitude input'),
      currentZoomEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-tool-current-zoom input'),
      debugMarkerIcon: '{{uc_assets_url}}' + 'unlimited_elements_icon.png',
      markerToggleEl: document.querySelector('#{{uc_id}} .ue-google-map__locator-hide-show-marker')
    },
    defaultMarker: {
      icon_type: '{{default_marker_icon_type}}',
      marker_list_icon: '{{default_marker_icon}}',
      marker_custom_icon: '{{default_marker_custom_image}}',
      icon_letter: '{{default_marker_icon_letter}}',
      marker_width_nounit: '{{default_marker_width_nounit}}',
      marker_height_nounit: '{{default_marker_height_nounit}}',
      ue_svg_marker: '{{ue_svg_marker}}',
      animate_marker: {{animate_marker}}
    },
    clustering: {
      show: {{use_marker_cluster}},
      imagesPath: '{{uc_assets_url}}' + 'img/clustering',
      maxZoom: {{cluster_max_zoom}},
      gridSize: {{cluster_grid_size}}
    },
    navigation: {
      showPlaces: {% if navigation == "hide" %} false {% else %} true {% endif %},
      showSearch: {{show_places_search}},
      places: document.querySelectorAll('#{{uc_id}} .ue-google-map_navigator-item'),
      searchInput: document.querySelector('#{{uc_id}} .ue-google-map_search-input'),
      searchIcon: document.querySelector('#{{uc_id}} .ue-google-map_search-icon'),
      resetButton: document.querySelector('#{{uc_id}} .ue-google-map_reset-btn'),
      showReset: {{show_map_reset_button}},
      placesWrapper: document.querySelector('#{{uc_id}} .ue-google-map_places-wrapper'),
      placesToggle: document.querySelector('#{{uc_id}} .ue-google-map_navigator-toggle'),
      placesToggleText: document.querySelector('#{{uc_id}} .ue-google-map_navigator-toggle-text'),  
      placesToggleIcon: document.querySelector('#{{uc_id}} .ue-google-map_navigator-toggle-icon'),    
      categoryToggleClass: '.ue-google-map_category-title',
      categoryTitleWrapperClass: ".ue-google-map_category-title",
      categoryTitleClass: '.ue-google-map_category-name',
      categoryCheckboxClass: '.ue-google-map_category-checkbox input',
      placeItemsClass: '.ue-google-map_category-items'
    },
    errorOverlay: {
        wrapper: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay'),
        closeButton: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-close-btn'),
        geocodedValueEl: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-geocoded-value'),
        statusEl: document.querySelector('#{{uc_id}} .ue-google-map__error-overlay-status'),
    },
    loader: document.querySelector('#{{uc_id}} .ue-google-map__loader'),
    breakpoint: {{responsive_breakpoint}},
    container: document.querySelector('#{{uc_id}}'),
    isEditMode: {% if uc_inside_editor == "yes" %} true {% else %} false {% endif %},
    isRefreshed: isRefreshed,
  }      
                                                       
 
  if(isRefreshed) {
      const tempMarkers = []
      options.navigation.places.forEach( place => {
       tempMarkers.push(options.markers.find( m => m.title === place.getAttribute('aria-label')))
      })
    
      options.markers = tempMarkers;
  }
                 
  map_{{uc_id}} = new UeGoogleMapWidget(options);
                                                                                
  {% if enable_map_interaction_inside_elementor_editor == 'true' %}
    document.querySelector('#{{uc_id}}').parentElement.addEventListener('mousedown', (e) => { e.stopPropagation() });
  {% endif %} 
  
  {% if close_after_outside_info_window_click  == "true" %}    
    function getObjDialog(objItem){
      var objDialog = objItem.parents('[role="dialog"]');
      return(objDialog);
  }
   
  function getObjCloseButton(){
      
      if(!jQuery(infoWindowItems))
      return(false);
      
      var objCloseButton;

      jQuery(infoWindowItems).each(function(){
          var objItem = jQuery(this);
          var objDialog = getObjDialog(objItem);

          if(!objDialog || objDialog.length == 0)
          return(true);

          objCloseButton = objDialog.find("button");

          if(!objCloseButton || objCloseButton.length == 0)
          return(true);
        
          return(objCloseButton);
      });
      return(objCloseButton);
  }
   
  function onMapClick(objCloseButton){           
      objCloseButton.trigger("click");
  }
   
  jQuery(options.dom).on("click", function(e){
      var objTarget = jQuery(e.target);   
      var objDom = jQuery(this);
      var targetTypeAttr = objTarget.attr("type");
      var targetRoleAttr = objTarget.attr("role");
      var targetTagName = objTarget.prop("tagName");
      
      if(targetTypeAttr == "button" || targetRoleAttr == "button" || targetTagName == "IMG" || targetTagName == "BUTTON")
      return(true);  
        
      var objCloseButton = getObjCloseButton();      
     
      if(!objCloseButton || objCloseButton.length == 0)
      return(true);
      
      var objParentDialog = getObjDialog(objCloseButton);
      
      if(!objParentDialog || objParentDialog.length == 0)
      return(true);
            
      var objTargetParentDialog = getObjDialog(objTarget);
            
      if(!objTargetParentDialog || objTargetParentDialog.length == 0)      
      onMapClick(objCloseButton);
    
  });
  {% endif %}// end close_after_outside_info_window_click
}		
   
{{ ucfunc("put_docready_start") }}    

    if(g_isGoogleMapInited == true )      
       ucInitGoogleMap{{uc_serial}}(); 
    else{      
      g_arrInitCallbacks.push(ucInitGoogleMap{{uc_serial}});   
    }  
   
  var objWrpaper = jQuery("#{{uc_id}}");
   
  objWrpaper.on("uc_ajax_refreshed", () => {  
    
    if(typeof map_{{uc_id}} !== "undefined"){
      map_{{uc_id}}.removePlacesToggleHandler() 
      map_{{uc_id}} = null;
    }
        
    if(g_isGoogleMapInited == true )
    ucInitGoogleMap{{uc_serial}}();
    else
    g_arrInitCallbacks.push(ucInitGoogleMap{{uc_serial}});
  });

{{ ucfunc("put_docready_end") }}