{% set currentCategory = ucfunc("get","currentCategory") %}
{% set itemsTotal = ucfunc("get","itemsTotal") %}
{% set categoryExist = ucfunc("get","categoryExist") %}
{# empty div to collect item data #}{##}
{% set itemSettingsElem %}
  <div class="ue-google-map-setting-item" data-settings='{
   "icon_type": "{{item.icon_type}}",
   "marker_custom_icon": "{{item.marker_custom_icon}}",
   "ue_svg_marker": "{{item.ue_svg_marker}}",   
   "marker_list_icon": "{{item.marker_list_icon}}",
   "icon_letter": "{{item.icon_letter}}",  
   "title": {{item.title|json_encode|e('html_attr')}},  
   "item_type": "{{item.item_type}}",         
   "coordinates_type": "{{item.coordinates_type}}",               
   "marker_latitude": "{{item.marker_latitude|e('html_attr')}}",
   "marker_longitude": "{{item.marker_longitude|e('html_attr')}}",
   "zoom_level": "{{item.zoom_level}}",
   "item_index":  {{item.item_index}}                                                         
  }'></div>
{% endset %}{# end empty div to collect item data #}{##}

{% if item.item_type == "category"  %}

	{% if currentCategory == 0 %}

      {% set currentCategory = 1 %}
      {{ ucfunc("set","currentCategory",currentCategory) }}
	  {% set categoryExist = "true" %}
      {{ ucfunc("set","categoryExist",categoryExist) }}	
	
	{% else %}
	  {% set currentCategory = currentCategory + 1 %}
      {{ ucfunc("set","currentCategory",currentCategory) }}

      </div>
      </div>
      <div class="ue-maps-navigator-item-spacing"></div>
	
	{% endif %}

      <div  class="ue-google-map_category ue-google-map_navigator-item" data-item-type="category" data-category-index="{{currentCategory}}" data-item_index="{{item.item_index}}">
        
        {{itemSettingsElem}}
        
        <div class="ue-google-map_category-content">
          <div class="ue-google-map_category-title">
          {% if show_category_check_box == "true"  %}
           
            <div class="ue-google-map_category-checkbox">
              <input id="checkbox{{item.item_index}}" class="uc-checkbox" type="checkbox" checked>
	          <label for="checkbox{{item.item_index}}" class="uc-checkbox-label">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                <path fill="none" stroke="{{checkbox_color}}" stroke-width="3" d="M1.73 12.91l6.37 6.37L22.79 4.59"></path>
              </svg>
            </div>
              
            <div class="ue-google-map_category-checkbox-spacing"></div>
          {% endif %}
          <div class="ue-google-map_category-name ue-maps-navigator-item-label" tabindex="0" aria-role="button" aria-roledescription="{{item.title|raw}} Map Items Category">{{item.title|raw}} <span class="ue-google-map_category-items-count"></span></div>
          
          {% if enable_accordion == "true"  %}  
          <div class="ue-google-map_category-toggle 
                      {% if accordion_on_open == 'expand_all' %} ue_active
                      {% elseif ( accordion_on_open == 'expand_first' ) and ( currentCategory == '1' ) %} ue_active
                      {% endif %}" 
               tabindex="0" aria-role="button" aria-roledescription="{{item.title|raw}} Map Items Cateory Toggle">
            <span class="ue-google-map_category-toggle-icon ue-google-map_category-toggle-open"> {{toggle_open_html|raw}}</span>
            <span class="ue-google-map_category-toggle-icon ue-google-map_category-toggle-close"> {{toggle_close_html|raw}}</span>
          </div>
          {% endif %}
            
          </div>
          <!-- end category title -->
        </div>
        <div class="ue-google-map_category-items">
     
{% endif %}

{% if item.item_type == "place"  %}

	{% set currentCategory = ucfunc("get","currentCategory") %}

	<div aria-label="{{item.title|raw}}" aria-role="button" aria-roledescription="{{item.title|raw}} Map Item" tabindex="0" class="ue-google-map_places-item ue-google-map_navigator-item" data-item-type="place" data-category-index = {% if currentCategory != "" %} "{{currentCategory}}" {% else %} "null" {% endif %} data-item_index="{{item.item_index}}">
       
        {{itemSettingsElem}}
      
		{% if image == "bg" %}
            <img class="ue-maps-navigator-item-background-image" src="{{item.place_image}}" {{item.place_image_attributes|raw}}>
            <div class="ue-maps-navigator-item-background-overlay"></div>
        {% endif %}	

        {% if image == "thumb" %}
            <div class="ue-maps-navigator-item-image"><img src="{% if item.place_image is empty %}{{uc_assets_url}}/no-image.png{% else %}{{item.place_image}}{% endif %}" {{item.place_image_attributes|raw}}></div>
            <div class="ue-maps-navigator-item-image-spacing"></div>
        {% endif %}	

        <div class="ue-maps-navigator-item-content">
            {% if show_title_in_navigation == "true" %}<div class="ue-maps-navigator-item-title ue-maps-navigator-item-label">{{item.title|raw}}</div>{% endif %}	
            <div class="ue-maps-navigator-item-sub-title">{{item.place_address|raw}}</div>
        </div>

    </div>

    <div class="ue-maps-navigator-item-spacing"></div>

{% endif %}
          

{% if ( categoryExist == "true" ) and ( itemsTotal == item.item_index ) %}
  </div>
  </div>
  <div class="ue-maps-navigator-item-spacing"></div>
{% endif %}