{# twig vars #}{##}
{% set apiKey = ucfunc("get_general_setting","google_map_key")%}
{# end twig vars #}{##}


{%if apiKey == ""%}
  <div class="uc-error-message">
      Google Map API Key not found. Please set it in General Settings - Integrations tab.       	
  </div>
{%else%}

  {% if ucfunc("run_code_once","google_map_script") %}
    <script>
       if(typeof g_arrInitCallbacks == "undefined") 
      	 var g_arrInitCallbacks = [];
       
       if(typeof g_isGoogleMapInited == "undefined")
       	 var g_isGoogleMapInited = false;
		
       function ucInitMaps(){
         
           g_isGoogleMapInited = true;
           if(!g_arrInitCallbacks || g_arrInitCallbacks.length == 0)
             return(false);

           for(index in g_arrInitCallbacks)
             g_arrInitCallbacks[index]();
      }
        
      if(typeof UCaddGoogleMapsScript == "undefined")
        function UCaddGoogleMapsScript(){
          
          const script1 = document.createElement('script');
          script1.src = "https://maps.googleapis.com/maps/api/js?key={{apiKey}}&loading=async&{% if ( language == 'custom' ) %}language={{language_code|raw}}&{%endif%}callback=ucInitMaps&libraries=&v=weekly";
          script1.async = true;
          document.body.appendChild(script1);      
        }
              
        if(g_isGoogleMapInited !== true)
        	UCaddGoogleMapsScript();

</script>

  {% endif %}

{% set currentCategory = 0 %}
{{ ucfunc("set","currentCategory",currentCategory) }}
{% set itemsTotal = uc_num_items %}
{{ ucfunc("set","itemsTotal",itemsTotal) }}
{% set categoryExist = "false" %}
{{ ucfunc("set","categoryExist",categoryExist) }}

  <div id="{{uc_id}}" class="ue-google-map {{uc_filtering_addclass}} {{uc_dynamic_popup_class}}" {{uc_filtering_attributes|raw}}>
    <div class="ue-google-map__loader ue_shimmer"></div>
    {% if show_the_locator_tool == "true" %}
      <div class="ue-google-map__locator-tool">
        <div class="ue-google-map__locator-tool-header">
         <div class="ue-google-map__locator-tool-note">* Search for coordinates by address and copy the Longitude and Latitude into your maps settings</div>
         
         <div class="ue-google-map__locator-tool-toggles">
               <div class="ue-google-map__locator-hide-show-marker">
                 
                  <span class="ue-google-map__locator-show-marker" title="Hide Tool Marker">
                    <i class="fas fa-eye"></i>
                  </span>
                 
                  <span class="ue-google-map__locator-hide-marker" title="Show Tool Marker">
                    <i class="fas fa-eye-slash"></i>
                  </span>
                
           </div>
                
                <div class="ue-google-map__locator-hide-show-map-current" title="Show / Hide Map Coordinates" {% if current_location_button == "false" %}style="display: none;"{% endif %}><i class="fas fa-map"></i></div>
          </div>
        </div>
     <div class="ue-google-map__locator-tool-marker-details">
        <div class="ue-google-map__locator-tool-address">
          <label>Marker Address: 
             <input type="text" value="New York"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Address" aria-role="button" aria-roledescription="Copy Address Button" tabindex="0" data-copy="adrress"></i>
          <i class="ue-google-map__locator-tool-address__search eicon-arrow-right" aria-label="Geocode Address" aria-role="button" aria-roledescription="Geocode Address to latitude and longitude" tabindex="0"></i>
        </div>
        <div class="ue-google-map__locator-tool-latitude">
          <label>Marker Latitude: 
             <input type="number"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Latitude" aria-role="button" aria-roledescription="Copy Latitude Button" tabindex="0" data-copy="latitude"></i>
        </div>
        <div class="ue-google-map__locator-tool-longitude">
          <label>Marker Longitude: 
             <input type="number"/>
          </label>
          <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Longitude" aria-role="button" aria-roledescription="Copy longitude Button" tabindex="0" data-copy="longitude"></i>
          <i class="ue-google-map__locator-tool-longitude__search eicon-arrow-right" aria-label="Geocode Coordinates" aria-role="button" aria-roledescription="Geocode latitude and longitude to address" tabindex="0"></i>
        </div>
        <div class="ue-google-map__locator-tool-zoom">
          <label>Zoom: 
             <input type="number" min="1" max="24" step="1"/>
          </label>
        </div>
        <div class="ue-google-map__locator-tool-notes">
          <label>Notes: 
             <input type="text" placeholder="type a note..."/>
          </label>
        </div>
       
        </div>        
        
        <div class="ue-google-map__locator-tool-current-location-wrapper">
          <div class="ue-google-map__locator-tool-current-latitude">
            <label>Map Current Latitude: 
              <input type="number" class="cft-transparent" />
            </label>
            <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Current Latitude" aria-role="button" aria-roledescription="Copy Current Latitude Button" tabindex="0" data-copy="current-latitude"></i>
          </div>
          <div class="ue-google-map__locator-tool-current-longitude">
            <label>Map Current Longitude: 
              <input type="number" class="cft-transparent"/>
            </label>
            <i class="ue-google-map__locator-tool__button-copy eicon-copy" aria-label="Copy Current Longitude" aria-role="button" aria-roledescription="Copy Current longitude Button" tabindex="0" data-copy="current-longitude"></i>
          </div>
        
        </div>
        
      </div>
    {% endif %}
    <div class="ue-google-map_container">
      {% if navigation == "before"  %}
        <div class="ue-google-map_places-wrapper" {% if show_the_locator_tool == "true" %} style="opacity: 0;" {% endif %}>
          {% if show_places_search == "true" %}
            <div class="ue-google-map_search-wrapper">
              <div class="ue-google-map_search-input-wrapper">
                <input tabindex="0" id="mapSearch" class="ue-google-map_search-input" type="text" placeholder="{{search_placeholder|raw}}"> 
                <span aria-roledescription="Search Map Items" class="ue-google-map_search-icon">{{search_icon_html|raw}}</span>
              </div>
             </div>
          {% endif %}

          <div tabindex="0" class="ue-google-map_places-list uc-items-wrapper">
            {{put_items()}}
          </div>
        </div>
      {% endif %}   
      
      <div class="uc-google-map__overlays">
        
        {% if show_map_reset_button == "true" %}
          	<button class="ue-google-map_reset-btn" aria-label="Reset" aria-role="button" aria-roledescription="Reset Map" tabindex="0" title="Reset Map">{{reset_button_icon_html|raw}}</button>
        {% endif %}
        
        <div aria-label="Map" aria-role="application" aria-roledescription="map" class="ue-google-map__wrapper">
        </div>
      </div>
      
      {% if navigation == "after" or navigation == "hide"  %}
        <div class="ue-google-map_places-wrapper" {% if show_the_locator_tool == "true" %} style="opacity: 0;" {% endif %}>
        {% if show_places_search == "true" %}
          <div class="ue-google-map_search-wrapper">
            <div class="ue-google-map_search-input-wrapper">
              <input tabindex="0" id="mapSearch" class="ue-google-map_search-input" type="text" placeholder="{{search_placeholder|raw}}"> 
              <span aria-roledescription="Search Map Items" class="ue-google-map_search-icon">{{search_icon_html|raw}}</span>
            </div>
           </div>
        {% endif %}

        <div tabindex="0" class="ue-google-map_places-list uc-items-wrapper">
          {{put_items()}}
        </div>
      </div>
      {% endif %}      
      
      {% if navigation == "before" or navigation == "after" %}
        <div class="ue-google-map_navigator-toggle" data-open-text="{{open_navigator|raw}}" data-close-text="{{close_navigator|raw}}" data-pos="{{navigator_position}}">
          {% if show_navigation_button_icon == "true" %}
          	<span class="ue-google-map_navigator-toggle-icon ue-google-map_navigator-toggle-icon--open">{{navigation_button_icon_open_html|raw}}</span>
            <span class="ue-google-map_navigator-toggle-icon ue-google-map_navigator-toggle-icon--close">{{navigation_button_icon_close_html|raw}}</span>
          {% endif %}
          <span class="ue-google-map_navigator-toggle-text">{{open_navigator|raw}}</span>
        </div>
      {% endif %}        
      
    </div>
    <div class="ue-google-map_places-hidden-placeholders uc-items-wrapper2">
         {{put_items2()}}
    </div>
    <div class="ue-google-map__error-overlay">
      <div class="ue-google-map__error-overlay-content">
        <span class="ue-google-map__error-overlay-close-btn">×</span>
        <div class="ue-google-map__error-overlay-title">Geocoding Error Occured.</div>
        <p>Tried to Geocode: <span class="ue-google-map__error-overlay-geocoded-value"></span></p>
        <p>Error Type: <span class="ue-google-map__error-overlay-status"></span></p>
        <p>Please be sure to follow the tutorial on how to setup the Google APIs required for the Advanced Google Map Widget.</p>
        <a href="https://unlimited-elements.com/docs/google-map-api-key/">Google Map API Key Tutorial </a>
      </div>
    </div>
  </div>
{% endif %}