#{{uc_id}} {
    display: flex;
    align-items: center;
}
#{{uc_id}} .ue-gradient-border .ue-gradient-border-content .ue-txt {
  		z-index: 2;
        position:relative;
}
{% if fill_type == "color" %}
    #{{uc_id}} .ue-gradient-border .ue-gradient-border-content .ue-txt {
        color: {{text_color}};
    }

    #{{uc_id}} .ue-gradient-border:hover .ue-gradient-border-content .ue-txt {
        color: {{text_color_hover}};
    }
{% endif %}

{% if fill_type == "gradient" %}
    @supports ((-webkit-background-clip: text) or (background-clip: text)) and ((-webkit-text-fill-color: transparent) or (text-fill-color: transparent)) {
        #{{uc_id}} .ue-gradient-border .ue-gradient-border-content .ue-txt {
            background: linear-gradient({{text_gradient_angle}}deg, {{gradient_color_one}}, {{gradient_color_two}});
            background-size: cover;
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            text-fill-color: transparent;
            
        }

        #{{uc_id}} .ue-gradient-border:hover .ue-gradient-border-content .ue-txt {
            background: linear-gradient({{text_gradient_angle_hover}}deg, {{gradient_color_one_hover}}, {{gradient_color_two_hover}});
            background-size: cover;
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            text-fill-color: transparent;
        }
    }
{% endif %}
#{{uc_id}} .ue-gradient-border .ue-gradient-border-icon {
  		z-index: 2;
        position:relative;
}
{% if fill_type_icon == "color" %}
    #{{uc_id}} .ue-gradient-border .ue-gradient-border-icon i {
        color: {{icon_color}};
    }

    #{{uc_id}} .ue-gradient-border:hover .ue-gradient-border-icon i  {
        color: {{icon_color_hover}};
    }
{% endif %}

{% if fill_type_icon == "gradient" %}
    @supports ((-webkit-background-clip: text) or (background-clip: text)) and ((-webkit-text-fill-color: transparent) or (text-fill-color: transparent)) {
        #{{uc_id}} .ue-gradient-border .ue-gradient-border-icon i {
            background: linear-gradient({{icon_gradient_angle}}deg, {{icon_grad_first_color}}, {{icon_grad_second_color}});
            background-size: cover;
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            text-fill-color: transparent;
            
        }

        #{{uc_id}} .ue-gradient-border:hover .ue-gradient-border-icon i {
            background: linear-gradient({{icon_gradient_angle_hover}}deg, {{icon_grad_first_color_hover}}, {{icon_grad_second_color_hover}});            background-size: cover;
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            text-fill-color: transparent;
        }
    }
{% endif %}

#{{uc_id}} .ue-gradient-border {
    position: relative;
    display: inline-block;
    z-index: 0;
}

#{{uc_id}} .ue-gradient-border-content {
    background:
        {% if background_type == "color" %}
            linear-gradient(90deg, {{color}}, {{color}}) padding-box,
        {% endif %}
        {% if background_type == "gradient" %}
            linear-gradient({{ gradient_angle_background }}deg, {{ background_first_color }}, {{ background_second_color }}) padding-box,
        {% endif %}
        linear-gradient({{ gradient_angle }}deg, {{ border_first_color }}, {{ border_second_color }}, {{ border_first_color }}, {{ border_second_color }}, {{ border_first_color }}, {{ border_second_color }}) border-box;
    border: {{border_width}}px solid transparent;
    display:flex;
    justify-content:center;
    align-items:center;
    position:relative;
    overflow:hidden;
    background-size:450%;
    background-position:0%;
	transition: background-position 0.5s ease; 
    {% if ((movement_on == "normal") or (movement_on == "both")) and (moving_gradient == "true") %}
    animation: moveBackAndForth {{time}}s ease-in-out infinite;
    {% endif %}
}

#{{uc_id}} .ue-gradient-border-content:hover {
        background:
        {% if background_type == "color" %}
            linear-gradient(90deg, {{color_hover}}, {{color_hover}}) padding-box,
        {% endif %}
        {% if background_type == "gradient" %}
            linear-gradient({{ gradient_angle_background }}deg, {{ background_first_color }}, {{ background_second_color }}) padding-box,
        {% endif %}
        linear-gradient({{ gradient_angle }}deg, {{ border_first_color }}, {{ border_second_color }}, {{ border_first_color }}, {{ border_second_color }}, {{ border_first_color }}, {{ border_second_color }}) border-box;
    border: {{border_width}}px solid transparent;
        background-size:450%;
        background-position: 0%; 
        {% if ((movement_on == "hover") or (movement_on == "both")) and (moving_gradient == "true") %}
        animation: moveBackAndForth {{time}}s ease-in-out infinite;
        {% endif %}
		
}
#{{uc_id}} .ue-grad-hover
{       
        position:absolute;
        top:0;
        left:0;
        right:0;
        bottom:0;
        width:100%;
        height:100%;
        z-index:0;
        background:
        {% if background_type == "color" %}
            linear-gradient(90deg, {{color_hover}}, {{color_hover}});
        {% endif %}
        {% if background_type == "gradient" %}
            linear-gradient({{ gradient_angle_background_hover }}deg, {{ background_first_color_hover }}, {{ background_second_color_hover }});
        {% endif %}
		opacity:0;
        transition: opacity {{transition_time}}s ease-in-out; 
}
#{{uc_id}} .ue-grad-normal
{       
        position:absolute;
        top:0;
        left:0;
        right:0;
        bottom:0;
        width:100%;
        height:100%;
        z-index:1;
        background:
        {% if background_type == "color" %}
            linear-gradient(90deg, {{color}}, {{color}});
        {% endif %}
        {% if background_type == "gradient" %}
            linear-gradient({{ gradient_angle_background }}deg, {{ background_first_color }}, {{ background_second_color}});
        {% endif %}
		opacity:1;
        transition: opacity {{transition_time}}s ease-in-out; 
}
#{{uc_id}} .ue-gradient-border:hover .ue-grad-hover
{
        opacity:1;
        
}
#{{uc_id}} .ue-gradient-border:hover .ue-grad-normal
{
        opacity:0;
}
@keyframes moveBackAndForth {
    0% {
        background-position: 0%;
    }
    50% {
        background-position: 100%;
    }
    100% {
        background-position: 0%;
    }
}
{% if glow == "true" %}
    #{{uc_id}} .ue-gradient-border .ue-grad-blur {
        content: '';
        position: absolute;
        top: -{{ border_width }}px;
        left: -{{ border_width }}px;
        right: -{{ border_width }}px;
        bottom: -{{ border_width }}px;
        background: linear-gradient({{glow_gradient_angle}}deg, {{glow_first_color}}, {{glow_second_color}});
        z-index: -1;
        border-radius: {{ border_radius }};
        filter: blur({{glow_value}});
		{% if blink == "true" %}
        animation: blinkAnimation {{blink_time}}s infinite alternate;
      	{% endif %}
    }

    #{{uc_id}} .ue-gradient-border:hover .ue-grad-blur {
      
        background: linear-gradient({{glow_gradient_angle_hover}}deg, {{glow_first_color_hover}}, {{glow_second_color_hover}});
        {% if blink == "true" %}
        animation: blinkAnimation {{blink_time}}s infinite alternate;
      	{% endif %}
    }
    @keyframes blinkAnimation {
    0% {
        transform: scale(1);
        opacity: 1;
    }
    100% {
        transform: scale(1.15);
        opacity: 1; /* Adjust opacity if necessary */
    }
}
{% endif %}