.ue-flipbox-carousel{
  min-height:1px;
}

/* carousel type owl */
{% if carousel_type == "owl" %}
  #{{uc_id}} .owl-stage-outer{
    display: block;
  }

  #{{uc_id}} .owl-nav .owl-prev{
    position:absolute;
    display:inline-block;
    text-align:center;
    outline:none;
    padding: 0;
    margin:0;
  }

  #{{uc_id}} .owl-nav .owl-next{
    position:absolute;
    display:inline-block;
    text-align:center;
    outline:none;
    padding: 0;
    margin:0;
  }

  #{{uc_id}} .owl-dots {
    display: block;
    overflow:hidden;
    text-align:{{dot_alignment}};
  }

  #{{uc_id}} .owl-dots button{
    padding: 0;
  }

  #{{uc_id}} .owl-dot {
    border-radius:50%;
    display:inline-block;
  }
{% endif %}
/* end carousel type owl */

/* carosuel type marquee */
{% if carousel_type == "marquee" %}
  #{{uc_id}} .uc_logo_marquee_holder .ue-flip-box__description a{
    display: inline-block;
    height: auto;
    width: auto;
  }
{% endif %}
/* end carousel type marquee */

#{{uc_id}} .ue-flip-box__panel.ue-flip-box__panel--front,
#{{uc_id}} .ue-flip-box__panel.ue-flip-box__panel--back {
    backface-visibility: hidden;
    -webkit-backface-visibility: hidden; 
}

#{{uc_id}} .ue-flip-box__panel--back .ue_btn{
	display: {{button_style}};
}

{% if ( anim_effect == "flip" ) or ( anim_effect == "flip-alt" )  %} 

	{% if add_3d_depth == "true"  %}
        #{{uc_id}} .ue-flip-box__panel__wrapper { 
            transform: translateZ(90px) scale(0.91);
            transform-style: preserve-3d;
        }	
    {% endif %}

{% else %}
	
	#{{uc_id}} .ue-flip-box__container, #{{uc_id}} .ue-flip-box__panel {
      overflow: hidden;
    }
	
{% endif %}

{% if show_overlay == "true" %}
  #{{uc_id}} .ue-flip-box__overlay {
    position: fixed;
  	top: 0;
    left: 0;
    width: 100vw;
    height: 100vh;
  	opacity: 0;
  	z-index: -1;
  	transition: all 0.3s;
    bottom:0;
    right:0;
  }

  #{{uc_id}} .ue-flip-box__container.uc-show { 
      z-index: 3;
  }

  #{{uc_id}} .ue-flip-box__container.uc-show + .ue-flip-box__overlay { 
    	opacity: 1;
    	z-index: 2;
  }
{% endif %}

{% if animation_trigger == "trigger_button" %}
#{{uc_id}} .ue-flip-box__front-trigger{
  position:absolute;
  {{front_trigger_horizontal_position}}:{{front_trigger_horizontal_spacing}}px;
  {{front_trigger_vertical_position}}:{{front_trigger_vertical_spacing}}px;
  cursor:pointer;
  line-height:1em;
  display:block;
}

#{{uc_id}} .ue-flip-box__front-trigger svg{
  width:1em;
  height:1em;
}

#{{uc_id}} .ue-flip-box__back-trigger{
  position:absolute;
  {{back_trigger_horizontal_position}}:{{back_trigger_horizontal_spacing}}px;
  {{back_trigger_vertical_position}}:{{back_trigger_vertical_spacing}}px;
  cursor:pointer;
  line-height:1em;
  display:block;
}

#{{uc_id}} .ue-flip-box__back-trigger svg{
  width:1em;
  height:1em;
}
{% endif %}

#{{uc_id}} .ue-flip-box__panel--front-overlay{
  position:absolute;
  top:0;
  bottom:0;
  right:0;
  left:0;
  z-index:-1;
}

#{{uc_id}} .ue-flip-box__panel--back-overlay{
  position:absolute;
  top:0;
  bottom:0;
  right:0;
  left:0;
  z-index:-1;
}

#{{uc_id}} .ue-flip-box{
  transition:0.3s;
  {% if show_icons == "true" and change_back_link_icons_position_to_outside == "true" %}
  display: flex;
  flex-direction: column;
  {% endif %}
}

{% if show_icons == "true" %}
  #{{uc_id}} .ue-flip-box-icons {
     width: 100%;
     display: flex;
  }

  #{{uc_id}} .ue-flip-box-icons a{
    display:inline-flex;
    text-decoration:none;
    align-items:center;
    justify-content:center;
    line-height:1em;
    transition:0.3s;
    pointer-events:all;
  }

  #{{uc_id}} .ue-flip-box-icons a svg{
    width:1em;
    height:1em;
  }
{% endif %}