jQuery(document).ready(function () {
 
  var objRemoteApi = new UERemoteWidgets();
 
	  objRemoteApi.onWidgetInit("{{uc_id}}",function(objWidget){
       
       var objButtons = objWidget.find(".ue-item-button");               
       var isHashSet = objWidget.data('hash');
       var isHashLoaded = false; //helps to enable active item change with hash
 
       function setHash(objItem) {
         
         	  if(isHashSet == false)
              return(false);

              var objitemDataNum = objItem.data("numitem");

              window.location.hash = "remote-item-nav-" + objitemDataNum;
       }   
        
       function getHashedNum() {

          if (!window.location.hash) 
          return false;
         
          if(isHashLoaded == true)
          return(false);
       
          var hashedNum = window.location.hash.replace("#remote-item-nav-", "");
           			
          return Number(hashedNum);
         
  		}  
        
        //checks if in vieport 
        function isElementInViewport(element) {

            var elementTop = element.offset().top;
            var elementBottom = elementTop + element.outerHeight();

            var viewportTop = jQuery(window).scrollTop();
            var viewportBottom = viewportTop + jQuery(window).height();

            var isInViwport = elementBottom > viewportTop && elementTop < viewportBottom;

            return(isInViwport);
        } 

        //scrolls to element if needed
        function scrollToHead(elementOffsetTop){			

            jQuery('html, body').animate({
                scrollTop: elementOffsetTop
            }, 400);

        }
        
        function checkHashAndTriggerButton(){
        
          if(isHashSet == false)
          return(false);
          
          if (!window.location.hash) 
          return false;
          
          var currentItemNum = getHashedNum();
          
          var objHashedButtons = jQuery('.remote_item_navigation[data-hash="true"] .ue-item-button[data-numitem="'+currentItemNum+'"]');
          
          var objHashedButtonsNum = objHashedButtons.length;
          
          if(!objHashedButtonsNum)
          return(false); 
                    
          if(objHashedButtonsNum == 1){
            
            objHashedButtons.trigger('click');

            var objHashedItemOffsetTop = objHashedButtons.offset().top;

            if(isElementInViewport(objHashedButtons) == false)
            scrollToHead(objHashedItemOffsetTop);
            
          }
          
          if(objHashedButtonsNum > 1){          
            
          	objHashedButtons.each(function(index, button){
            	
              	if(index != 0)
                return(true);
              	
              	var objHashedButton = jQuery(this);
                            
              	objHashedButton.trigger('click');                           	

                var objHashedItemOffsetTop = objHashedButton.offset().top;

                if(isElementInViewport(objHashedButton) == false)
                scrollToHead(objHashedItemOffsetTop);
            
            });
          
          }
          
          isHashLoaded = true; //after loading from hash let currentItem to make counts
          
        }        
        
        // define function set/remove active mote
        
        function updateActiveMode() {
         
         var currentItem;
         var itemsNum = objButtons.length;
         
         if(isHashSet == true){
                      
         	if(getHashedNum() - 1 >= itemsNum || getHashedNum() == false)
            currentItem = objRemoteApi.doAction("get_num_current");
           	else
         	currentItem = getHashedNum() - 1;           
                       
         }         
         
         if(isHashSet == false || isHashSet == undefined)
         currentItem = objRemoteApi.doAction("get_num_current"); 
         
         currentItem++;
          
          objButtons.each(function(event, button){
          		var objButton = jQuery(button);
            
            	var buttonNumItem = objButton.data("numitem");
                        
            	if(buttonNumItem == currentItem)
              		objButton.addClass("ue-item-active");
               	else
              		objButton.removeClass("ue-item-active");
          });
         
       }
        
       updateActiveMode();
        
       setTimeout(checkHashAndTriggerButton,400);
        
       objRemoteApi.onEvent("change", updateActiveMode);

       objButtons.on('click', function() {    
         
         	var objButton = jQuery(this);
         	
         	setHash(objButton);
         
            var buttonNumItem = objButton.data("numitem");
            var itemToSet = buttonNumItem-1;     
        	objRemoteApi.doAction("change_item", itemToSet); 
       });
        
       {% if breakpoint == "true" and swipe_to_scroll == "true" %}
       //drag to scroll  
        
        var objWrapper = objWidget.find(".ue-items-wrapper");
        const slider = objWrapper[0];
       
        let isDown = false;
        let startX;
        let scrollLeft;

        slider.addEventListener('mousedown', (e) => {
          isDown = true;
          slider.classList.add('active');
          startX = e.pageX - slider.offsetLeft;
          scrollLeft = slider.scrollLeft;
        });

        slider.addEventListener('mouseleave', () => {
          isDown = false;
          slider.classList.remove('active');
        });

        slider.addEventListener('mouseup', () => {
          isDown = false;
          slider.classList.remove('active');
        });

        slider.addEventListener('mousemove', (e) => {
          if(!isDown) return;
          e.preventDefault();
          const x = e.pageX - slider.offsetLeft;
          const walk = (x - startX) * 1; //scroll-speed
          slider.scrollLeft = scrollLeft - walk;
        });        
        
        
        {% if show_navigation_arrows == "true" %}
        //scroll using arrows
        
			var objNextArrow = objWidget.find(".remote_item_navigation-next");
         	var objPrevArrow = objWidget.find(".remote_item_navigation-prev");
         
         	function smoothScroll(element, distance) {
               
              const currentPosition = element.scrollLeft();
              const targetPosition = currentPosition + distance;
              const duration = 300; // Duration of the animation in milliseconds

              element.animate({scrollLeft:targetPosition}, duration);               
            }
         
         	objNextArrow.on("click", function(){
              	smoothScroll(objWrapper, 100)
            });
         
         	objPrevArrow.on("click", function(){
            	smoothScroll(objWrapper, -100)
            });
            
        {% endif %}	
       
       {% endif %}	
        
    });
});