#{{uc_id}}
{
  display:flex;
  flex-wrap: wrap;
  position: relative;
}

#{{uc_id}} .ue-items-wrapper{
  display:flex;
  flex-wrap: wrap;
  transition: all .3s;
}

#{{uc_id}} .ue-item-button
{
  display:flex;
  cursor:pointer;
  transition:0.3s;
}

#{{uc_id}} .ue-item-hero
{
  display:flex;
  justify-content:center;
  align-items:center;
  position:relative;
  transition:0.3s;
}

#{{uc_id}} .ue-item-hero svg
{
  height:1em;
  width:1em;
  transition:0.3s;
}

#{{uc_id}} .ue-item-hero .ue-item-hero-label
{
  position:absolute;
  {{horizontal_snap}}:{{horizontal_space}};
  {{vertical_snap}}:{{vertical_space}};
  display:flex;
  justify-content:center;
  align-items:center;
  transition:0.3s;
}

#{{uc_id}} .ue-item-hero-img
{
  top:50%;
  left:50%;
  transform: translate(-50%, -50%);
  position:absolute;
  transition:0.3s;
}

#{{uc_id}} .remote_item_navigation-arrows{
  display: none;
}

#{{uc_id}} .remote_item_navigation-next,
#{{uc_id}} .remote_item_navigation-prev{
  cursor: pointer;
  position: absolute;
  z-index: 1;
  display: flex;
  justify-content: center;
  align-items: center;
  transition: all .3s;
}


{% if ucfunc("run_code_once", "yourkey") == true %}

.ue-item-hero-label
{
  line-height:1em; 
  font-size:10px;
  transition:0.3s;
}

.ue-item-hero-icon
{
  position:relative;
  transition:0.3s;
}

.ue-item-button-title
{
  transition:0.3s;
}

{% endif %}

@media only screen and (max-width: {{navigation_arrows_breakpoint}}px){

  #{{uc_id}} .remote_item_navigation-arrows{
    display: block;
  }

}

@media only screen and (max-width: {{responsive_breakpoint}}px){
	    
  {% if swipe_to_scroll == "true" %}

    #{{uc_id}} .ue-items-wrapper{
       justify-content:unset;
       flex-wrap: nowrap;
       overflow-x: scroll; 
       cursor: grab;
    }

    #{{uc_id}} .ue-items-wrapper::-webkit-scrollbar{
       display: none;
    }

  {% endif %}
	
}