{% set class = "" %}

{% if(item.item_index == 1) and item.tab_number is empty %}
	{% if (first_active == "true") %}
		{% set class = "ue-item-active" %}
	{% endif %}
{% endif %}

{% set tabid = "ue-item-" ~ item.item_index %}

{% if item.friendly_hash_name is not empty %}
	{% set tabid = item.friendly_hash_name %}
{% endif %}

<div id="ue-remote-tabs-{{tabid}}" class="ue-item {{hover}} {{item.item_repeater_class}} {{class}}" data-id="{{tabid}}" data-custom-hash="{{item.friendly_hash_name|raw}}" data-tab-number="{{item.tab_number}}">
    
  <a class="ue-item-link" {% if item.add_link == "true" %}href="{{item.link|raw}}" {{item.link_html_attributes|raw}}{% endif %}>
  
  {% if graphic_element == "icon" %}<div class="ue-item-icon">{{item.icon_html|raw}}</div> <div class="ue-item-element-gap"></div>{% endif %}
  {% if graphic_element == "image" %}<div class="ue-item-image"><img src="{{item.image}}" {{item.image_attributes|raw}}></div> <div class="ue-item-element-gap"></div>{% endif %}
  
  <div>
    {% if show_title == "true" %}<div class="ue-item-title">{{item.title|raw}}</div>{% endif %}
    {% if show_text == "true" %}<div class="ue-item-text">{{item.text|raw}}</div>{% endif %}
  </div>
  
  {% if show_label == "true" %}
    <div class="ue-item-label {{vertical_snap}} {{horizontal_snap}}">{{item.label|raw}}</div>
  {% endif %}
  
  </a>
  
</div>