<div class="uc_bold_tabs ue_repeater_tabs {{remote_parent.class|raw}}" id="{{uc_id}}" data-scrolltohead="{{scroll_to_head}}" data-close-active="{{close_active_tab_on_click}}" {{remote_parent.attributes|raw}} {{uc_filtering_attributes|raw}}>

  <ul class="tabs uc-items-wrapper ue-tab-btns">
     {# repeater items for tab headers #}{##}
     {% for repeater_item in choose_repeater %}
      
       {# twig vars #}{##}
       {% set itemIndex = loop.index0 %}
       {% set itemId = "ue-item" ~ loop.index0 %}
       {% set titleField = repeater_item[tabs_title_field_name] %}
       {# end twig vars #}{##}

       <li class="ue_repeater_tabs-item {{itemId}}">
         <a class="ue_repeater_tabs-item-anchor" href="#btss-{{itemIndex}}{{uc_id}}">
           {% if show_increment == "true" %}<div class="ue_repeater_tabs_increment">{{itemIndex}}</div>{% endif %}
           {{titleField|raw}}
         </a>
       </li>

     {% endfor %}
   </ul>
  
   <div class="panel-container uc-items-wrapper2">
    {# repeater items for tab content #}{##}
    {% for repeater_item in choose_repeater %}
      
      {# twig vars #}{##}
      {% set itemIndex = loop.index0 %}
      {% set itemId = "ue-item" ~ loop.index0 %}
      {% set titleField = repeater_item[tabs_title_field_name] %}
      {% set contentTitleField = repeater_item[content_title_field_name] %}
      {% set contentField = repeater_item[tabs_content_field_name] %}
      {% set imageField = repeater_item[tabs_image_field_name] %}
      {% set imageAltAttr = repeater_item[tabs_image_field_name ~ "_alt"] %}
      {% set buttonTextField = repeater_item[tabs_button_text_field_name] %}
      {% set buttonLinkField = repeater_item[tabs_button_link_field_name] %}
      {# end twig vars #}{##}

      <div id="btss-{{itemIndex}}{{uc_id}}" class="tab-container panes" >
        <div class="ue_repeater_tabs_container">
          {% if show_post_image == "true" %}
             <div class="ue_repeater_image">
               {% if imageField is empty %}
                 {% if fallback_image is empty %}
                 <img src="{{uc_assets_url}}/missing-image.png" alt="No Image">
                 {% else %}
                 <img src="{{fallback_image}}" alt="No Image">
                 {% endif %}
               {% else %}
                 <img src="{{imageField}}" alt="{{imageAltAttr}}">
               {% endif %}
             </div>
          {% endif %}
          <div class="ue_repeater_tab_content">
            {% if show_post_title == "true" %}<{{title_tag}} class="ue_repeater_title">{{contentTitleField|raw}}</{{title_tag}}>{% endif %}
            {% if show_post_text == "true" %}<div class="ue_repeater_intro">{{contentField|truncate(intro_number_of_characters)|raw}}</div>{% endif %}
            {% if show_post_button == "true" %}
              <a class="ue_repeater_link" href="{{buttonLinkField}}" target="{{open_links_in_new_tab}}">
               {% if buttonTextField is not empty %}{{buttonTextField}}{% else %}{{button_text|raw}}{% endif %}
              </a>
            {% endif %}
          </div>
        </div> 
      </div>

    {% endfor %}
   </div>

   <div class="uc-accordion-contents-template" style="display:none">
     <div class="uc-accordion-icon">
       <span class="uc-accordion-icon-expand">{{accordion_expand_icon_html|raw}}</span>
       <span class="uc-accordion-icon-collapse">{{accordion_collapse_icon_html|raw}}</span>
     </div>
   </div>

</div>